from typing import Any, Dict, List, Union, cast

import attr

from ..models.custom_fields import CustomFields
from ..models.fields import Fields
from ..types import UNSET, Unset


@attr.s(auto_attribs=True)
class CustomEntityBaseRequest:
    """  """

    aliases: Union[Unset, List[str]] = UNSET
    custom_fields: Union[CustomFields, Unset] = UNSET
    fields: Union[Fields, Unset] = UNSET
    folder_id: Union[Unset, str] = UNSET
    name: Union[Unset, str] = UNSET
    schema_id: Union[Unset, str] = UNSET

    def to_dict(self) -> Dict[str, Any]:
        aliases: Union[Unset, List[Any]] = UNSET
        if not isinstance(self.aliases, Unset):
            aliases = self.aliases

        custom_fields: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.custom_fields, Unset):
            custom_fields = self.custom_fields.to_dict()

        fields: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.fields, Unset):
            fields = self.fields.to_dict()

        folder_id = self.folder_id
        name = self.name
        schema_id = self.schema_id

        field_dict: Dict[str, Any] = {}
        field_dict.update({})
        if aliases is not UNSET:
            field_dict["aliases"] = aliases
        if custom_fields is not UNSET:
            field_dict["customFields"] = custom_fields
        if fields is not UNSET:
            field_dict["fields"] = fields
        if folder_id is not UNSET:
            field_dict["folderId"] = folder_id
        if name is not UNSET:
            field_dict["name"] = name
        if schema_id is not UNSET:
            field_dict["schemaId"] = schema_id

        return field_dict

    @staticmethod
    def from_dict(src_dict: Dict[str, Any]) -> "CustomEntityBaseRequest":
        d = src_dict.copy()
        aliases = cast(List[str], d.pop("aliases", UNSET))

        custom_fields: Union[CustomFields, Unset] = UNSET
        _custom_fields = d.pop("customFields", UNSET)
        if _custom_fields is not None and not isinstance(_custom_fields, Unset):
            custom_fields = CustomFields.from_dict(cast(Dict[str, Any], _custom_fields))

        fields: Union[Fields, Unset] = UNSET
        _fields = d.pop("fields", UNSET)
        if _fields is not None and not isinstance(_fields, Unset):
            fields = Fields.from_dict(cast(Dict[str, Any], _fields))

        folder_id = d.pop("folderId", UNSET)

        name = d.pop("name", UNSET)

        schema_id = d.pop("schemaId", UNSET)

        custom_entity_base_request = CustomEntityBaseRequest(
            aliases=aliases,
            custom_fields=custom_fields,
            fields=fields,
            folder_id=folder_id,
            name=name,
            schema_id=schema_id,
        )

        return custom_entity_base_request
