from typing import Any, Dict, Optional, Union, cast

import attr

from ..models.fields import Fields
from ..models.measurement import Measurement
from ..types import UNSET, Unset


@attr.s(auto_attribs=True)
class ContainerUpdate:
    """  """

    project_id: Union[Unset, Optional[str]] = UNSET
    volume: Union[Measurement, Unset] = UNSET
    fields: Union[Fields, Unset] = UNSET
    name: Union[Unset, str] = UNSET
    parent_storage_id: Union[Unset, str] = UNSET

    def to_dict(self) -> Dict[str, Any]:
        project_id = self.project_id
        volume: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.volume, Unset):
            volume = self.volume.to_dict()

        fields: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.fields, Unset):
            fields = self.fields.to_dict()

        name = self.name
        parent_storage_id = self.parent_storage_id

        field_dict: Dict[str, Any] = {}
        field_dict.update({})
        if project_id is not UNSET:
            field_dict["projectId"] = project_id
        if volume is not UNSET:
            field_dict["volume"] = volume
        if fields is not UNSET:
            field_dict["fields"] = fields
        if name is not UNSET:
            field_dict["name"] = name
        if parent_storage_id is not UNSET:
            field_dict["parentStorageId"] = parent_storage_id

        return field_dict

    @staticmethod
    def from_dict(src_dict: Dict[str, Any]) -> "ContainerUpdate":
        d = src_dict.copy()
        project_id = d.pop("projectId", UNSET)

        volume: Union[Measurement, Unset] = UNSET
        _volume = d.pop("volume", UNSET)
        if _volume is not None and not isinstance(_volume, Unset):
            volume = Measurement.from_dict(cast(Dict[str, Any], _volume))

        fields: Union[Fields, Unset] = UNSET
        _fields = d.pop("fields", UNSET)
        if _fields is not None and not isinstance(_fields, Unset):
            fields = Fields.from_dict(cast(Dict[str, Any], _fields))

        name = d.pop("name", UNSET)

        parent_storage_id = d.pop("parentStorageId", UNSET)

        container_update = ContainerUpdate(
            project_id=project_id,
            volume=volume,
            fields=fields,
            name=name,
            parent_storage_id=parent_storage_id,
        )

        return container_update
