from typing import Any, Dict, Union, cast

import attr

from ..models.fields import Fields
from ..types import UNSET, Unset


@attr.s(auto_attribs=True)
class BoxUpdate:
    """  """

    name: Union[Unset, str] = UNSET
    fields: Union[Fields, Unset] = UNSET
    parent_storage_id: Union[Unset, str] = UNSET
    project_id: Union[Unset, str] = UNSET

    def to_dict(self) -> Dict[str, Any]:
        name = self.name
        fields: Union[Unset, Dict[str, Any]] = UNSET
        if not isinstance(self.fields, Unset):
            fields = self.fields.to_dict()

        parent_storage_id = self.parent_storage_id
        project_id = self.project_id

        field_dict: Dict[str, Any] = {}
        field_dict.update({})
        if name is not UNSET:
            field_dict["name"] = name
        if fields is not UNSET:
            field_dict["fields"] = fields
        if parent_storage_id is not UNSET:
            field_dict["parentStorageId"] = parent_storage_id
        if project_id is not UNSET:
            field_dict["projectId"] = project_id

        return field_dict

    @staticmethod
    def from_dict(src_dict: Dict[str, Any]) -> "BoxUpdate":
        d = src_dict.copy()
        name = d.pop("name", UNSET)

        fields: Union[Fields, Unset] = UNSET
        _fields = d.pop("fields", UNSET)
        if _fields is not None and not isinstance(_fields, Unset):
            fields = Fields.from_dict(cast(Dict[str, Any], _fields))

        parent_storage_id = d.pop("parentStorageId", UNSET)

        project_id = d.pop("projectId", UNSET)

        box_update = BoxUpdate(
            name=name,
            fields=fields,
            parent_storage_id=parent_storage_id,
            project_id=project_id,
        )

        return box_update
