from typing import Any, Dict, Union

import attr

from ..models.blob_type import BlobType
from ..models.blob_upload_status import BlobUploadStatus
from ..types import UNSET, Unset


@attr.s(auto_attribs=True)
class Blob:
    """  """

    id: Union[Unset, str] = UNSET
    name: Union[Unset, str] = UNSET
    type: Union[Unset, BlobType] = UNSET
    mime_type: Union[Unset, str] = UNSET
    upload_status: Union[Unset, BlobUploadStatus] = UNSET

    def to_dict(self) -> Dict[str, Any]:
        id = self.id
        name = self.name
        type: Union[Unset, BlobType] = UNSET
        if not isinstance(self.type, Unset):
            type = self.type

        mime_type = self.mime_type
        upload_status: Union[Unset, BlobUploadStatus] = UNSET
        if not isinstance(self.upload_status, Unset):
            upload_status = self.upload_status

        field_dict: Dict[str, Any] = {}
        field_dict.update({})
        if id is not UNSET:
            field_dict["id"] = id
        if name is not UNSET:
            field_dict["name"] = name
        if type is not UNSET:
            field_dict["type"] = type
        if mime_type is not UNSET:
            field_dict["mimeType"] = mime_type
        if upload_status is not UNSET:
            field_dict["uploadStatus"] = upload_status

        return field_dict

    @staticmethod
    def from_dict(src_dict: Dict[str, Any]) -> "Blob":
        d = src_dict.copy()
        id = d.pop("id", UNSET)

        name = d.pop("name", UNSET)

        type = None
        _type = d.pop("type", UNSET)
        if _type is not None:
            type = BlobType(_type)

        mime_type = d.pop("mimeType", UNSET)

        upload_status = None
        _upload_status = d.pop("uploadStatus", UNSET)
        if _upload_status is not None:
            upload_status = BlobUploadStatus(_upload_status)

        blob = Blob(
            id=id,
            name=name,
            type=type,
            mime_type=mime_type,
            upload_status=upload_status,
        )

        return blob
