from typing import Any, Dict, List

import attr

from ..models.batch import Batch


@attr.s(auto_attribs=True)
class BatchesBulkGet:
    """  """

    batches: List[Batch]

    def to_dict(self) -> Dict[str, Any]:
        batches = []
        for batches_item_data in self.batches:
            batches_item = batches_item_data.to_dict()

            batches.append(batches_item)

        field_dict: Dict[str, Any] = {}
        field_dict.update(
            {
                "batches": batches,
            }
        )

        return field_dict

    @staticmethod
    def from_dict(src_dict: Dict[str, Any]) -> "BatchesBulkGet":
        d = src_dict.copy()
        batches = []
        _batches = d.pop("batches")
        for batches_item_data in _batches:
            batches_item = Batch.from_dict(batches_item_data)

            batches.append(batches_item)

        batches_bulk_get = BatchesBulkGet(
            batches=batches,
        )

        return batches_bulk_get
