from typing import Any, Dict, List, Union

import attr

from ..types import UNSET, Unset


@attr.s(auto_attribs=True)
class BadRequestErrorBulkErrorErrorsItem:
    """  """

    index: Union[Unset, float] = UNSET
    message: Union[Unset, str] = UNSET
    additional_properties: Dict[str, Any] = attr.ib(init=False, factory=dict)

    def to_dict(self) -> Dict[str, Any]:
        index = self.index
        message = self.message

        field_dict: Dict[str, Any] = {}
        field_dict.update(self.additional_properties)
        field_dict.update({})
        if index is not UNSET:
            field_dict["index"] = index
        if message is not UNSET:
            field_dict["message"] = message

        return field_dict

    @staticmethod
    def from_dict(src_dict: Dict[str, Any]) -> "BadRequestErrorBulkErrorErrorsItem":
        d = src_dict.copy()
        index = d.pop("index", UNSET)

        message = d.pop("message", UNSET)

        bad_request_error_bulk_error_errors_item = BadRequestErrorBulkErrorErrorsItem(
            index=index,
            message=message,
        )

        bad_request_error_bulk_error_errors_item.additional_properties = d
        return bad_request_error_bulk_error_errors_item

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> Any:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: Any) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
