from setuptools import setup
from setuptools.command.install import install
import os
import sys
import pypandoc

class ManPageGenerator(install):
    def run(self):
        here = os.path.dirname(__file__) or '.'
        files = []
        outfile = 'notcurses-pydemo.1'
        pypandoc.convert_file(os.path.join(here, 'notcurses-pydemo.1.md'), 'man', outputfile=outfile, extra_args=['-s'])
        files.append(outfile)
        # this breaks when using --user without --prefix
        ipage = (os.path.join(self.prefix, 'share', 'man', 'man1'), files)
        self.distribution.data_files.append(ipage)
        print("data_files: ", self.distribution.data_files)
        super().run()

def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()

setup(
    name="notcurses",
    version="1.6.15",
    packages=['notcurses'],
    scripts=['notcurses-pydemo'],
    package_dir={'': 'src'},
    author="Nick Black",
    author_email="nickblack@linux.com",
    description="Blingful TUI construction library (python bindings)",
    keywords="ncurses curses tui console graphics",
    license='Apache License, Version 2.0',
    url='https://github.com/dankamongmen/notcurses',
    zip_safe=True,
    platforms=["any"],
    long_description=read('README.md'),
    long_description_content_type="text/markdown",
    data_files=[],
    install_requires=["cffi>=1.0.0"],
    setup_requires=["cffi>=1.0.0"],
    cffi_modules=["src/notcurses/build_notcurses.py:ffibuild"],
    # see https://pypi.org/pypi?%3Aaction=list_classifiers
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'License :: OSI Approved :: Apache Software License',
        'Natural Language :: English',
        'Programming Language :: Python',
    ],
    include_package_data=True,
    cmdclass=dict(
        install=ManPageGenerator,
    )
)
