# Generated by Django 2.1.7 on 2019-03-05 21:54

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Identifier',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('serializer', models.CharField(max_length=255)),
                ('name', models.CharField(max_length=255)),
                ('field', models.CharField(blank=True, max_length=255, null=True)),
                ('value', models.CharField(blank=True, max_length=255, null=True)),
                ('attr_id', models.PositiveIntegerField(blank=True, null=True)),
                ('resolved', models.BooleanField(default=False)),
            ],
        ),
        migrations.CreateModel(
            name='Range',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('list', 'Data Column'), ('value', 'Header metadata'), ('data', 'Cell value')], max_length=10)),
                ('header_col', models.IntegerField()),
                ('start_col', models.IntegerField()),
                ('end_col', models.IntegerField(blank=True, null=True)),
                ('header_row', models.IntegerField()),
                ('start_row', models.IntegerField()),
                ('end_row', models.IntegerField(blank=True, null=True)),
                ('count', models.IntegerField(blank=True, null=True)),
                ('identifier', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='data_wizard.Identifier')),
            ],
            options={
                'ordering': ('run_id', '-type', 'start_row', 'start_col', 'pk'),
            },
        ),
        migrations.CreateModel(
            name='Record',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('row', models.PositiveIntegerField()),
                ('success', models.BooleanField(default=True)),
                ('fail_reason', models.TextField(blank=True, null=True)),
                ('content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='contenttypes.ContentType')),
            ],
            options={
                'ordering': ('run_id', 'row'),
            },
        ),
        migrations.CreateModel(
            name='Run',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('record_count', models.IntegerField(blank=True, null=True)),
                ('loader', models.CharField(default='data_wizard.loaders.FileLoader', max_length=255)),
                ('serializer', models.CharField(blank=True, max_length=255, null=True)),
                ('object_id', models.PositiveIntegerField(blank=True, null=True)),
                ('content_type', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='contenttypes.ContentType')),
                ('template', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='data_wizard.Run')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ('-pk',),
            },
        ),
        migrations.CreateModel(
            name='RunLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('event', models.CharField(max_length=100)),
                ('date', models.DateTimeField(auto_now_add=True)),
                ('run', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='log', to='data_wizard.Run')),
            ],
            options={
                'ordering': ('date',),
            },
        ),
        migrations.AddField(
            model_name='record',
            name='run',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='data_wizard.Run'),
        ),
        migrations.AddField(
            model_name='range',
            name='run',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='data_wizard.Run'),
        ),
    ]
