__version__ = "0.3"
__author__ = "Thomas Baldauf"
__email__ = "thomas.baldauf@dlr.de"
__license__ = "MIT"
__birthdate__ = '15.11.2021'
__status__ = 'prod' # options are: dev, test, prod


class Singleton(object):
    """
    Plain vanilla singleton class
    """
    _instance = None
    __initialized = False

    def __new__(cls, *args, **kwargs):
        if not cls._instance:
            cls._instance = super(Singleton, cls).__new__(cls) # , *args, **kwargs)
        return cls._instance

    @property
    def do_init(self):
        return not self.__initialized

    def set_initialized(self):
        self.__initialized = True
