# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
import trident
import re
#sys.path.insert(0, os.path.abspath('C:/Users/Allan/PycharmProjects/DeepTrident/trident'))

# -- Project information -----------------------------------------------------

project = 'trident'
copyright = '2020, AllanYiin'
author = 'AllanYiin'

# The full version, including alpha/beta/rc tags
release = '5.5.0'


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.viewcode',
    'sphinx.ext.extlinks',
    'sphinx.ext.napoleon',
    'nbsphinx',
    'recommonmark',
    'IPython.sphinxext.ipython_console_highlighting'
]

# Suppress warnings
suppress_warnings = ['image.nonlocal_uri']
# Define source suffix
source_suffix = ['.rst', '.ipynb','.md']

master_doc = 'index'
# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

autodoc_mock_imports = [
    'tensorflow','torch','cntk','opencv','numpy'
]


# sphinx.ext.napoleon options
napoleon_google_docstring = True
napoleon_numpy_docstring = False

add_module_names = False

# Linkcheck builder options


source_prefix = 'https://github.com/AllanYiin/trident'



# sphinx.ext.extlinks options
extlinks = {
    'tridenttw': (source_prefix + '/docs/zh-tw/%s.md', ''),
    'tridentcn': (source_prefix + '/docs/zh-cn/%s.md', ''),
    'tridenten': (source_prefix + '/docs/en-us/%s.md', '')
}

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.

html_theme = 'sphinx_materialdesign_theme'
html_theme_options = {
    # Specify a list of menu in Header.
    # Tuples forms:
    #  ('Name', 'external url or path of pages in the document', boolean, 'icon name')
    #
    # Third argument:
    # True indicates an external link.
    # False indicates path of pages in the document.
    #
    # Fourth argument:
    # Specify the icon name.
    # For details see link.
    # https://material.io/icons/
    'header_links' : [
        ('Home', 'index', False, 'home'),
        ("ExternalLink", "http://example.com", True, 'launch'),
        ("NoIconLink", "http://example.com", True, ''),
        ("GitHub", "https://github.com/AllanYiin/trident", True, 'link')
    ],

    # Customize css colors.
    # For details see link.
    # https://getmdl.io/customize/index.html
    #
    # Values: amber, blue, brown, cyan deep_orange, deep_purple, green, grey, indigo, light_blue,
    #         light_green, lime, orange, pink, purple, red, teal, yellow(Default: indigo)
    'primary_color': 'deep_orange',
    # Values: Same as primary_color. (Default: pink)
    'accent_color': 'indigo',

    # Customize layout.
    # For details see link.
    # https://getmdl.io/components/index.html#layout-section
    'fixed_drawer': True,
    'fixed_header': True,
    'header_waterfall': True,
    'header_scroll': False,

    # Render title in header.
    # Values: True, False (Default: False)
    'show_header_title': True,
    # Render title in drawer.
    # Values: True, False (Default: True)
    'show_drawer_title': True,
    # Render footer.
    # Values: True, False (Default: True)
    'show_footer': True
}


# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']