# API References

## Insolver DataFrame

```{eval-rst}
 .. automodule:: insolver.frame.frame
   :members:
```

## Build-in transformations

### Core utils for transformations
```{eval-rst}
 .. automodule:: insolver.transforms.core
   :members:
```

### Basic data transformations
```{eval-rst}
 .. automodule:: insolver.transforms.basic
   :members:
```

### Person data methods

```{eval-rst}
 .. automodule:: insolver.transforms.person
   :members:
```

### Insurance data methods
```{eval-rst}
.. automodule:: insolver.transforms.insurance
   :members:
```

### Grouping and sorting data methods

```{eval-rst}
.. automodule:: insolver.transforms.grouping_sorting
   :members:
```

### Missing values imputation methods

```{eval-rst}
 .. automodule:: insolver.transforms.autofillna
   :members:
```

### Date and Datetime methods

```{eval-rst}
.. automodule:: insolver.transforms.date_time
   :members:
```

## Feature engineering
### Data preprocessing
```{eval-rst}
 .. automodule:: insolver.feature_engineering.feature_engineering
   :members:
```

### Feature selection

```{eval-rst}
 .. automodule:: insolver.feature_engineering.feature_selection
   :members:
```

### Dimensionality reduction

```{eval-rst}
 .. automodule:: insolver.feature_engineering.dimensionality_reduction
   :members:
```

### Sampling

```{eval-rst}
 .. automodule:: insolver.feature_engineering.sampling
   :members:
```

### Smoothing
```{eval-rst}
 .. automodule:: insolver.feature_engineering.smoothing
   :members:
```

### Normalization
```{eval-rst}
 .. automodule:: insolver.feature_engineering.normalization
   :members:
```

## Discretization

```{eval-rst}
 .. automodule:: insolver.discretization.discretizer
   :members:
```

```{eval-rst}
 .. automodule:: insolver.discretization.discretizer_utils
   :members:
   :undoc-members:
```

## Interpretation
### DiCE
```{eval-rst}
 .. automodule:: insolver.interpretation.dice
   :members:
```

### LIME
```{eval-rst}
 .. automodule:: insolver.interpretation.lime
   :members:
```

### Plots
```{eval-rst}
 .. automodule:: insolver.interpretation.plots
   :members:
```

## Model Wrappers

### Base Wrapper

```{eval-rst}
 .. automodule:: insolver.wrappers.base
   :members:
```
### Trivial Wrapper

```{eval-rst}
 .. automodule:: insolver.wrappers.trivial
   :members:
   :inherited-members:
```

### Generalized Linear Model Wrapper

```{eval-rst}
 .. automodule:: insolver.wrappers.glm
   :members:
   :inherited-members:
```

### Gradient Boosting Machine Wrapper

```{eval-rst}
 .. automodule:: insolver.wrappers.gbm
   :members:
   :inherited-members:
```

### Random Forest Wrapper

```{eval-rst}
 .. automodule:: insolver.wrappers.general
   :members:
   :inherited-members:
```

## Model Tools

### Model Comparison

```{eval-rst}
 .. automodule:: insolver.model_tools.model_comparison
   :members:
```

### Model utils

```{eval-rst}
 .. automodule:: insolver.model_tools.model_utils
   :members:
```
