---
myst:
  html_meta:
    "description": "Plone provides user-interface translations, or internationalization, using the plone.app.locales package."
    "property=og:description": "Plone provides user-interface translations, or internationalization, using the plone.app.locales package."
    "property=og:title": "i18n: internationalization of screen messages"
    "keywords": "Plone, plone.restapi, REST, API, i18n, internationalization, screen, messages"
---

# i18n: internationalization of screen messages

Plone already provides user-interface translations using the [`plone.app.locales`](https://pypi.org/project/plone.app.locales/) packages.

In `plone.restapi`, we also use those translations where the end user needs to have those translated strings.
This way the front-end work is easier.
You directly get from the server everything you need, instead of needing to query yet another endpoint to get the translations.

To do so, `plone.restapi` relies on Plone's language negotiation configuration, and lets Plone do the work of deciding in which language the messages should be shown.

For the content of a multilingual site built using [`plone.app.multilingual`](https://pypi.org/project/plone.app.multilingual/), this is an easy task.
Plone is configured to display texts in the language of the content object.
There is no need to ask anything of the REST API.

Nevertheless, when you want to query the Plone Site object of a multilingual site, or any other endpoint in a plain Plone site with multiple languages configured, you need to query the REST API for the language in which you want to have the messages.
Otherwise you will get the messages on the default language configured in Plone.

To achieve that, the REST API requires the use of the `Accept-Language` HTTP header being passed with the required language code.

You will also need to configure Plone to use browser request language negotiation.
To do so, you need to go the {guilabel}`Plone Control Panel`.
Go to the {guilabel}`Language Control Panel`.
Open the {guilabel}`Negotiation` configuration tab, and select the option {guilabel}`Use browser language request negotiation`.

Using this option, we can get the translated content type titles:

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/translated_messages_types.req
```

…and the response:

```{literalinclude} ../../src/plone/restapi/tests/http-examples/translated_messages_types.resp
:language: http
```

All the field titles and descriptions will also be translated.
For instance for the `Folder` content type:

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/translated_messages_types_folder.req
```

…and the response:

```{literalinclude} ../../src/plone/restapi/tests/http-examples/translated_messages_types_folder.resp
:language: http
```

In a given object, the workflow state and actions will be translated, too:

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/translated_messages_object_workflow.req
```

…and the response:

```{literalinclude} ../../src/plone/restapi/tests/http-examples/translated_messages_object_workflow.resp
:language: http
```

The same happens in the `@history` endpoint.
All the relevant messages will be shown translated:

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/translated_messages_object_history.req
```

…and the response:

```{literalinclude} ../../src/plone/restapi/tests/http-examples/translated_messages_object_history.resp
:language: http
```

The same happens in the `@addons` endpoint.
All addon names and descriptions will be shown translated:

```{eval-rst}
..  http:example:: curl httpie python-requests
    :request: ../../src/plone/restapi/tests/http-examples/translated_messages_addons.req
```

…and the response:

```{literalinclude} ../../src/plone/restapi/tests/http-examples/translated_messages_addons.resp
:language: http
```
