.. IMPORTANT: this file is auto-generated from borg's built-in help, do not edit!

.. _borg_key_change-algorithm:

borg key change-algorithm
-------------------------
.. code-block:: none

    borg [common options] key change-algorithm [options] ALGORITHM

.. only:: html

    .. class:: borg-options-table

    +-------------------------------------------------------+---------------+----------------------+
    | **positional arguments**                                                                     |
    +-------------------------------------------------------+---------------+----------------------+
    |                                                       | ``ALGORITHM`` | select key algorithm |
    +-------------------------------------------------------+---------------+----------------------+
    | .. class:: borg-common-opt-ref                                                               |
    |                                                                                              |
    | :ref:`common_options`                                                                        |
    +-------------------------------------------------------+---------------+----------------------+

    .. raw:: html

        <script type='text/javascript'>
        $(document).ready(function () {
            $('.borg-options-table colgroup').remove();
        })
        </script>

.. only:: latex

    ALGORITHM
        select key algorithm


    :ref:`common_options`
        |

Description
~~~~~~~~~~~

Change the algorithm we use to encrypt and authenticate the borg key.

Important: In a `repokey` mode (e.g. repokey-blake2) all users share the same key.
In this mode upgrading to `argon2` will make it impossible to access the repo for users who use an old version of borg.
We recommend upgrading to the latest stable version.

Important: In a `keyfile` mode (e.g. keyfile-blake2) each user has their own key (in ``~/.config/borg/keys``).
In this mode this command will only change the key used by the current user.
If you want to upgrade to `argon2` to strengthen security, you will have to upgrade each user's key individually.

Your repository is encrypted and authenticated with a key that is randomly generated by ``borg init``.
The key is encrypted and authenticated with your passphrase.

We currently support two choices:

1. argon2 - recommended. This algorithm is used by default when initialising a new repository.
   The key encryption key is derived from your passphrase via argon2-id.
   Argon2 is considered more modern and secure than pbkdf2.
2. pbkdf2 - the legacy algorithm. Use this if you want to access your repo via old versions of borg.
   The key encryption key is derived from your passphrase via PBKDF2-HMAC-SHA256.

Examples::

    # Upgrade an existing key to argon2
    borg key change-algorithm /path/to/repo argon2
    # Downgrade to pbkdf2 - use this if upgrading borg is not an option
    borg key change-algorithm /path/to/repo pbkdf2

