from decimal import Decimal

import chellow.rcrc
from chellow.utils import utc_datetime


def test_find_month(mocker):
    month_start = utc_datetime(2021, 8, 1)
    month_finish = utc_datetime(2021, 8, 31, 23, 30)
    lines = (
        "31/07/2021,R2,43,.8242326129622329115643528823920201145614",
        "31/07/2021,R2,44,.3021860091604243316988934044542893148275",
        "31/07/2021,R2,45,-.125245550276177195908034109124249919307",
        "31/07/2021,R2,46,.2826766523946168967889987035702005096416",
        "31/07/2021,R2,47,1.32128081991276052736571303854587624422",
        "31/07/2021,R2,48,2.27531693996115258153196553715849971287",
        "01/08/2021,R2,1,2.81463856912050784238966163576183148676",
        "01/08/2021,R2,2,2.1271484975872792834093396067986896815",
        "01/08/2021,R2,3,-.4065095844876174993727440865488313478716",
        "01/08/2021,R2,4,-.6715232368246782260417436135850886172051",
        "01/08/2021,R2,5,-1.28305913589198066773000021177835039894",
        "01/08/2021,R2,6,-.6408956777419324991224936393556405604168",
    )
    month_rcrcs = chellow.rcrc._find_month(lines, month_start, month_finish)
    assert month_rcrcs == {
        "01 00:00 Z": Decimal("2.1271484975872792834093396067986896815"),
        "01 00:30 Z": Decimal("-0.4065095844876174993727440865488313478716"),
        "01 01:00 Z": Decimal("-0.6715232368246782260417436135850886172051"),
        "01 01:30 Z": Decimal("-1.28305913589198066773000021177835039894"),
        "01 02:00 Z": Decimal("-0.6408956777419324991224936393556405604168"),
    }
