"""empty message

Revision ID: a0b871227e12
Revises: 
Create Date: 2022-01-28 15:31:40.886099

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = 'a0b871227e12'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('services',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('name', sa.String(length=255), nullable=False),
    sa.Column('system_name', sa.String(length=255), nullable=False),
    sa.Column('url_public', sa.String(length=255), nullable=False),
    sa.Column('url_internal', sa.String(length=255), nullable=False),
    sa.Column('url_service', sa.String(length=255), nullable=False),
    sa.Column('is_active', sa.Integer(), nullable=True),
    sa.Column('status', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('id')
    )
    op.create_table('users',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('email', sa.String(length=128), nullable=False),
    sa.Column('password', sa.String(length=512), nullable=True),
    sa.Column('is_enabled', sa.Integer(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.Column('last_visit_at', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('email'),
    sa.UniqueConstraint('id')
    )
    op.create_table('attrs',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('user', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('attr_name', sa.String(length=32), nullable=False),
    sa.Column('attr_type', sa.String(length=32), nullable=False),
    sa.Column('attr_value', sa.String(length=128), nullable=True),
    sa.ForeignKeyConstraint(['user'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('id'),
    sa.UniqueConstraint('user')
    )
    op.create_table('details',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('user', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('fname', sa.String(length=32), nullable=True),
    sa.Column('lname', sa.String(length=32), nullable=True),
    sa.Column('address', sa.String(length=32), nullable=True),
    sa.Column('city', sa.String(length=32), nullable=True),
    sa.Column('country', sa.String(length=32), nullable=True),
    sa.Column('state', sa.String(length=32), nullable=True),
    sa.Column('zipcode', sa.String(length=32), nullable=True),
    sa.ForeignKeyConstraint(['user'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('id'),
    sa.UniqueConstraint('user')
    )
    op.create_table('recovery_codes',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('user', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('recovery_code', sa.String(), nullable=False),
    sa.ForeignKeyConstraint(['user'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('id'),
    sa.UniqueConstraint('user')
    )
    op.create_table('secrets',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('user', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('secret', sa.String(length=255), nullable=False),
    sa.Column('acl', sa.String(length=255), nullable=True),
    sa.Column('status', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['user'], ['users.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('id'),
    sa.UniqueConstraint('user')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('secrets')
    op.drop_table('recovery_codes')
    op.drop_table('details')
    op.drop_table('attrs')
    op.drop_table('users')
    op.drop_table('services')
    # ### end Alembic commands ###
