from sigopt.orchestrate.lib.types import *


class TestTypes(object):
  def test_is_sequence(self):
    assert is_sequence([])
    assert is_sequence([1, 2, 3])
    assert is_sequence(())
    assert is_sequence((1, 2, 3))

    assert not is_sequence(None)
    assert not is_sequence(False)
    assert not is_sequence(True)
    assert not is_sequence(0)
    assert not is_sequence(1.0)
    assert not is_sequence('abc')
    assert not is_sequence({})
    assert not is_sequence({'a': 123})
    assert not is_sequence(set())
    assert not is_sequence(set((1, 'a')))
    assert not is_sequence({1, 'a'})
    assert not is_sequence(frozenset((1, 'a')))

  def test_is_string_sequence(self):
    assert is_string_sequence([])
    assert is_string_sequence(())
    assert is_string_sequence(('a', 'b', 'c'))
    assert is_string_sequence([''])
    assert is_string_sequence(['a'])
    assert is_string_sequence(['a', '', 'b'])

    assert not is_string_sequence(None)
    assert not is_string_sequence(True)
    assert not is_string_sequence(False)
    assert not is_string_sequence((None, 'a', 'b'))
    assert not is_string_sequence(['a', 1])
    assert not is_string_sequence(['b', None])
    assert not is_string_sequence(['a', 'b', True, 'c'])
    assert not is_string_sequence('string')
    assert not is_string_sequence(('a', False))

  def test_is_mapping(self):
    assert is_mapping({})
    assert is_mapping({'a': 123})

    assert not is_mapping([])
    assert not is_mapping([1, 2, 3])
    assert not is_mapping(())
    assert not is_mapping((1, 2, 3))
    assert not is_mapping(None)
    assert not is_mapping(False)
    assert not is_mapping(True)
    assert not is_mapping(0)
    assert not is_mapping(1.0)
    assert not is_mapping('abc')
    assert not is_mapping(set())
    assert not is_mapping(set((1, 'a')))
    assert not is_mapping({1, 'a'})
    assert not is_mapping(frozenset((1, 'a')))

  def test_is_set(self):
    assert is_set(set())
    assert is_set(set((1, 'a')))
    assert is_set({1, 'a'})
    assert is_set(frozenset((1, 'a')))

    assert not is_set({})
    assert not is_set({'a': 123})
    assert not is_set([])
    assert not is_set([1, 2, 3])
    assert not is_set(())
    assert not is_set((1, 2, 3))
    assert not is_set(None)
    assert not is_set(False)
    assert not is_set(True)
    assert not is_set(0)
    assert not is_set(1.0)
    assert not is_set('abc')

  def test_is_string(self):
    assert is_string('')
    assert is_string('abc')
    assert is_string('123')

    assert not is_string(set())
    assert not is_string(set((1, 'a')))
    assert not is_string({1, 'a'})
    assert not is_string(frozenset((1, 'a')))
    assert not is_string({})
    assert not is_string({'a': 123})
    assert not is_string([])
    assert not is_string([1, 2, 3])
    assert not is_string(())
    assert not is_string((1, 2, 3))
    assert not is_string(None)
    assert not is_string(False)
    assert not is_string(True)
    assert not is_string(0)
    assert not is_string(1.0)

  def test_is_integer(self):
    assert is_integer(0)
    assert is_integer(1)
    assert is_integer(-1)

    assert not is_integer(set())
    assert not is_integer(set((1, 'a')))
    assert not is_integer({1, 'a'})
    assert not is_integer(frozenset((1, 'a')))
    assert not is_integer({})
    assert not is_integer({'a': 123})
    assert not is_integer([])
    assert not is_integer([1, 2, 3])
    assert not is_integer(())
    assert not is_integer((1, 2, 3))
    assert not is_integer(None)
    assert not is_integer(False)
    assert not is_integer(True)
    assert not is_integer(1.0)
    assert not is_integer('')
    assert not is_integer('abc')
    assert not is_integer('123')

  def test_is_boolean(self):
    assert is_boolean(True)
    assert is_boolean(False)

    assert not is_boolean(set())
    assert not is_boolean(set((True, False)))
    assert not is_boolean({True, False})
    assert not is_boolean(frozenset((True, False)))
    assert not is_boolean({})
    assert not is_boolean({'a': True})
    assert not is_boolean([])
    assert not is_boolean([True, False])
    assert not is_boolean(())
    assert not is_boolean((True, False))
    assert not is_boolean('')
    assert not is_boolean(None)
    assert not is_boolean('abc')
    assert not is_boolean('123')
    assert not is_boolean('True')
    assert not is_boolean('False')
    assert not is_boolean('true')
    assert not is_boolean('false')
    assert not is_boolean(0)
    assert not is_boolean(1)
    assert not is_boolean(1.0)
    assert not is_boolean(-1)
