import type { TargetLanguage } from 'jsii-rosetta';
/**
 * Key prefix for the package data storage.
 */
export declare const STORAGE_KEY_PREFIX = "data/";
/**
 * Key suffix for storing npm package bundles.
 */
export declare const PACKAGE_KEY_SUFFIX = "/package.tgz";
/**
 * The key suffix for (TypeScript) assembly files
 */
export declare const ASSEMBLY_KEY_SUFFIX = "/assembly.json";
/**
 * The key suffix for assemblies in the provided language. This should NOT be
 * used for the TypeScript/JavaScript assembly however.
 */
export declare function assemblyKeySuffix(lang: TargetLanguage): string;
/**
 * The key for the catalog document.
 */
export declare const CATALOG_KEY = "catalog.json";
/**
 * Key prefix used by the built-in discovery function to store failed records.
 */
export declare const FAILED_KEY_PREFIX = "failed/";
/**
 * Key prefix used by the built-in discovery function to stage tarballs.
 */
export declare const STAGED_KEY_PREFIX = "staged/";
