import { RetentionDays } from '@aws-cdk/aws-logs';
import { IBucket } from '@aws-cdk/aws-s3';
import { IQueue } from '@aws-cdk/aws-sqs';
import { Construct } from '@aws-cdk/core';
export interface DiscoveryProps {
    /**
     * The queue to post package updated messages to
     */
    readonly queue: IQueue;
    /**
     * How long should execution logs be retained?
     *
     * @default RetentionDays.TEN_YEARS
     */
    readonly logRetention?: RetentionDays;
}
export declare class Discovery extends Construct {
    /**
     * The bucket in which the discovery function stages objects before notifying
     * the Construct Hub about them.
     */
    readonly bucket: IBucket;
    constructor(scope: Construct, id: string, props: DiscoveryProps);
}
