import type { Context } from 'aws-lambda';
import { AWSError, S3 } from 'aws-sdk';
/**
 * Regenerates the `catalog.json` object in the configured S3 bucket.
 *
 * @param event configuration for the rebuild job. In particular, the `rebuild`
 *              property can be set to `true` in order to trigger a full (i.e:
 *              non-incremental) rebuild of the object.
 * @param context the lambda context in which this execution runs.
 *
 * @returns the information about the updated S3 object.
 */
export declare function handler(event: {
    readonly rebuild?: boolean;
}, context: Context): Promise<import("aws-sdk/lib/request").PromiseResult<S3.PutObjectOutput, AWSError>>;
