from .version import version as __version__

# Only needed for side effects
from . import _initialize
from .exceptions import HALError

# autogenerated by 'robotpy-build create-imports hal hal._wpiHal'
from ._wpiHal import (
    AccelerometerRange,
    AddressableLEDData,
    AllianceStationID,
    AnalogTriggerType,
    CANDeviceType,
    CANManufacturer,
    CANStreamMessage,
    CAN_CloseStreamSession,
    CAN_GetCANStatus,
    CAN_OpenStreamSession,
    CAN_ReceiveMessage,
    CAN_SendMessage,
    ControlWord,
    CounterMode,
    EncoderEncodingType,
    EncoderIndexingType,
    HandleEnum,
    I2CPort,
    JoystickAxes,
    JoystickButtons,
    JoystickDescriptor,
    JoystickPOVs,
    MatchInfo,
    MatchType,
    PowerDistributionFaults,
    PowerDistributionStickyFaults,
    PowerDistributionType,
    PowerDistributionVersion,
    REVPHCompressorConfig,
    REVPHCompressorConfigType,
    REVPHFaults,
    REVPHStickyFaults,
    REVPHVersion,
    RuntimeType,
    SPIPort,
    SerialPort,
    SimBoolean,
    SimDevice,
    SimDouble,
    SimEnum,
    SimInt,
    SimLong,
    SimValue,
    SimValueDirection,
    allocateDigitalPWM,
    calibrateAnalogGyro,
    cancelNotifierAlarm,
    checkAnalogInputChannel,
    checkAnalogModule,
    checkAnalogOutputChannel,
    checkCTREPCMSolenoidChannel,
    checkDIOChannel,
    checkPWMChannel,
    checkPowerDistributionChannel,
    checkPowerDistributionModule,
    checkREVPHModuleNumber,
    checkREVPHSolenoidChannel,
    checkRelayChannel,
    cleanAnalogTrigger,
    cleanCAN,
    cleanInterrupts,
    cleanNotifier,
    cleanPowerDistribution,
    clearAllCTREPCMStickyFaults,
    clearCounterDownSource,
    clearCounterUpSource,
    clearPowerDistributionStickyFaults,
    clearREVPHStickyFaults,
    clearSerial,
    closeI2C,
    closeSPI,
    closeSerial,
    configureSPIAutoStall,
    createHandle,
    createPortHandle,
    createPortHandleForSPI,
    createSimDevice,
    createSimValue,
    createSimValueBoolean,
    createSimValueDouble,
    createSimValueEnum,
    createSimValueInt,
    createSimValueLong,
    disableSerialTermination,
    enableSerialTermination,
    exitMain,
    expandFPGATime,
    fireCTREPCMOneShot,
    fireREVPHOneShot,
    flushSerial,
    forceSPIAutoRead,
    freeAddressableLED,
    freeAnalogGyro,
    freeAnalogInputPort,
    freeAnalogOutputPort,
    freeCTREPCM,
    freeCounter,
    freeDIOPort,
    freeDigitalPWM,
    freeDutyCycle,
    freeEncoder,
    freePWMPort,
    freeREVPH,
    freeRelayPort,
    freeSPIAuto,
    freeSimDevice,
    getAccelerometerX,
    getAccelerometerY,
    getAccelerometerZ,
    getAccumulatorCount,
    getAccumulatorOutput,
    getAccumulatorValue,
    getAllianceStation,
    getAnalogAverageBits,
    getAnalogAverageValue,
    getAnalogAverageVoltage,
    getAnalogGyroAngle,
    getAnalogGyroCenter,
    getAnalogGyroOffset,
    getAnalogGyroRate,
    getAnalogLSBWeight,
    getAnalogOffset,
    getAnalogOutput,
    getAnalogOversampleBits,
    getAnalogSampleRate,
    getAnalogTriggerFPGAIndex,
    getAnalogTriggerInWindow,
    getAnalogTriggerOutput,
    getAnalogTriggerTriggerState,
    getAnalogValue,
    getAnalogValueToVolts,
    getAnalogVoltage,
    getAnalogVoltsToValue,
    getBrownedOut,
    getBrownoutVoltage,
    getCTREPCMClosedLoopControl,
    getCTREPCMCompressor,
    getCTREPCMCompressorCurrent,
    getCTREPCMCompressorCurrentTooHighFault,
    getCTREPCMCompressorCurrentTooHighStickyFault,
    getCTREPCMCompressorNotConnectedFault,
    getCTREPCMCompressorNotConnectedStickyFault,
    getCTREPCMCompressorShortedFault,
    getCTREPCMCompressorShortedStickyFault,
    getCTREPCMPressureSwitch,
    getCTREPCMSolenoidDisabledList,
    getCTREPCMSolenoidVoltageFault,
    getCTREPCMSolenoidVoltageStickyFault,
    getCTREPCMSolenoids,
    getControlWord,
    getCounter,
    getCounterDirection,
    getCounterPeriod,
    getCounterSamplesToAverage,
    getCounterStopped,
    getCurrentThreadPriority,
    getDIO,
    getDIODirection,
    getDutyCycleFPGAIndex,
    getDutyCycleFrequency,
    getDutyCycleOutput,
    getDutyCycleOutputRaw,
    getDutyCycleOutputScaleFactor,
    getEncoder,
    getEncoderDecodingScaleFactor,
    getEncoderDirection,
    getEncoderDistance,
    getEncoderDistancePerPulse,
    getEncoderEncodingScale,
    getEncoderEncodingType,
    getEncoderFPGAIndex,
    getEncoderPeriod,
    getEncoderRate,
    getEncoderRaw,
    getEncoderSamplesToAverage,
    getEncoderStopped,
    getErrorMessage,
    getFPGAButton,
    getFPGARevision,
    getFPGATime,
    getFPGAVersion,
    getFilterPeriod,
    getFilterSelect,
    getHandleIndex,
    getHandleType,
    getHandleTypedIndex,
    getJoystickAxes,
    getJoystickAxisType,
    getJoystickButtons,
    getJoystickDescriptor,
    getJoystickIsXbox,
    getJoystickName,
    getJoystickPOVs,
    getJoystickType,
    getLastError,
    getMatchInfo,
    getMatchTime,
    getNumAccumulators,
    getNumAddressableLEDs,
    getNumAnalogInputs,
    getNumAnalogOutputs,
    getNumAnalogTriggers,
    getNumCTREPCMModules,
    getNumCTREPDPChannels,
    getNumCTREPDPModules,
    getNumCTRESolenoidChannels,
    getNumCounters,
    getNumDigitalChannels,
    getNumDigitalHeaders,
    getNumDigitalPWMOutputs,
    getNumDutyCycles,
    getNumEncoders,
    getNumInterrupts,
    getNumPWMChannels,
    getNumPWMHeaders,
    getNumREVPDHChannels,
    getNumREVPDHModules,
    getNumREVPHChannels,
    getNumREVPHModules,
    getNumRelayChannels,
    getNumRelayHeaders,
    getPWMConfigRaw,
    getPWMCycleStartTime,
    getPWMEliminateDeadband,
    getPWMLoopTiming,
    getPWMPosition,
    getPWMRaw,
    getPWMSpeed,
    getPort,
    getPortHandleChannel,
    getPortHandleModule,
    getPortHandleSPIEnable,
    getPortWithModule,
    getPowerDistributionAllChannelCurrents,
    getPowerDistributionChannelCurrent,
    getPowerDistributionFaults,
    getPowerDistributionModuleNumber,
    getPowerDistributionNumChannels,
    getPowerDistributionStickyFaults,
    getPowerDistributionSwitchableChannel,
    getPowerDistributionTemperature,
    getPowerDistributionTotalCurrent,
    getPowerDistributionTotalEnergy,
    getPowerDistributionTotalPower,
    getPowerDistributionType,
    getPowerDistributionVersion,
    getPowerDistributionVoltage,
    getREVPH5VVoltage,
    getREVPHAnalogVoltage,
    getREVPHCompressor,
    getREVPHCompressorConfig,
    getREVPHCompressorCurrent,
    getREVPHFaults,
    getREVPHPressureSwitch,
    getREVPHSolenoidCurrent,
    getREVPHSolenoidVoltage,
    getREVPHSolenoids,
    getREVPHStickyFaults,
    getREVPHVersion,
    getREVPHVoltage,
    getRelay,
    getRuntimeType,
    getSPIAutoDroppedCount,
    getSPIHandle,
    getSerialBytesReceived,
    getSerialFD,
    getSimValue,
    getSimValueBoolean,
    getSimValueDouble,
    getSimValueEnum,
    getSimValueInt,
    getSimValueLong,
    getSystemActive,
    getSystemClockTicksPerMicrosecond,
    getUserActive3V3,
    getUserActive5V,
    getUserActive6V,
    getUserCurrent3V3,
    getUserCurrent5V,
    getUserCurrent6V,
    getUserCurrentFaults3V3,
    getUserCurrentFaults5V,
    getUserCurrentFaults6V,
    getUserVoltage3V3,
    getUserVoltage5V,
    getUserVoltage6V,
    getVinCurrent,
    getVinVoltage,
    hasMain,
    initAccumulator,
    initSPIAuto,
    initialize,
    initializeAddressableLED,
    initializeAnalogGyro,
    initializeAnalogInputPort,
    initializeAnalogOutputPort,
    initializeAnalogTrigger,
    initializeAnalogTriggerDutyCycle,
    initializeCAN,
    initializeCTREPCM,
    initializeCounter,
    initializeDIOPort,
    initializeDriverStation,
    initializeDutyCycle,
    initializeEncoder,
    initializeI2C,
    initializeInterrupts,
    initializeNotifier,
    initializePWMPort,
    initializePowerDistribution,
    initializeREVPH,
    initializeRelayPort,
    initializeSPI,
    initializeSerialPort,
    initializeSerialPortDirect,
    isAccumulatorChannel,
    isAnyPulsing,
    isHandleCorrectVersion,
    isHandleType,
    isNewControlData,
    isPulsing,
    latchPWMZero,
    # loadExtensions,
    # loadOneExtension,
    observeUserProgramAutonomous,
    observeUserProgramDisabled,
    observeUserProgramStarting,
    observeUserProgramTeleop,
    observeUserProgramTest,
    pulse,
    readCANPacketLatest,
    readCANPacketNew,
    readCANPacketTimeout,
    readI2C,
    readInterruptFallingTimestamp,
    readInterruptRisingTimestamp,
    readSPI,
    readSPIAutoReceivedData,
    readSerial,
    releaseDSMutex,
    releaseWaitingInterrupt,
    report,
    requestInterrupts,
    resetAccumulator,
    resetAnalogGyro,
    resetCounter,
    resetEncoder,
    resetPowerDistributionTotalEnergy,
    resetSimValue,
    runMain,
    sendConsoleLine,
    sendError,
    setAccelerometerActive,
    setAccelerometerRange,
    setAccumulatorCenter,
    setAccumulatorDeadband,
    setAddressableLEDBitTiming,
    setAddressableLEDLength,
    setAddressableLEDOutputPort,
    setAddressableLEDSyncTime,
    setAnalogAverageBits,
    setAnalogGyroDeadband,
    setAnalogGyroParameters,
    setAnalogGyroVoltsPerDegreePerSecond,
    setAnalogInputSimDevice,
    setAnalogOutput,
    setAnalogOversampleBits,
    setAnalogSampleRate,
    setAnalogTriggerAveraged,
    setAnalogTriggerFiltered,
    setAnalogTriggerLimitsDutyCycle,
    setAnalogTriggerLimitsRaw,
    setAnalogTriggerLimitsVoltage,
    setBrownoutVoltage,
    setCTREPCMClosedLoopControl,
    setCTREPCMOneShotDuration,
    setCTREPCMSolenoids,
    setCounterAverageSize,
    setCounterDownSource,
    setCounterDownSourceEdge,
    setCounterExternalDirectionMode,
    setCounterMaxPeriod,
    setCounterPulseLengthMode,
    setCounterReverseDirection,
    setCounterSamplesToAverage,
    setCounterSemiPeriodMode,
    setCounterUpDownMode,
    setCounterUpSource,
    setCounterUpSourceEdge,
    setCounterUpdateWhenEmpty,
    setCurrentThreadPriority,
    setDIO,
    setDIODirection,
    setDIOSimDevice,
    setDigitalPWMDutyCycle,
    setDigitalPWMOutputChannel,
    setDigitalPWMRate,
    # setDutyCycleSimDevice,
    setEncoderDistancePerPulse,
    setEncoderIndexSource,
    setEncoderMaxPeriod,
    setEncoderMinRate,
    setEncoderReverseDirection,
    setEncoderSamplesToAverage,
    setEncoderSimDevice,
    setFilterPeriod,
    setFilterSelect,
    setInterruptUpSourceEdge,
    setJoystickOutputs,
    setNotifierName,
    setNotifierThreadPriority,
    setPWMConfig,
    setPWMConfigRaw,
    setPWMDisabled,
    setPWMEliminateDeadband,
    setPWMPeriodScale,
    setPWMPosition,
    setPWMRaw,
    setPWMSpeed,
    setPowerDistributionSwitchableChannel,
    setREVPHClosedLoopControlAnalog,
    setREVPHClosedLoopControlDigital,
    setREVPHClosedLoopControlDisabled,
    setREVPHClosedLoopControlHybrid,
    setREVPHCompressorConfig,
    setREVPHSolenoids,
    setRelay,
    setSPIAutoTransmitData,
    setSPIChipSelectActiveHigh,
    setSPIChipSelectActiveLow,
    setSPIHandle,
    setSPIOpts,
    setSPISpeed,
    setSerialBaudRate,
    setSerialDataBits,
    setSerialFlowControl,
    setSerialParity,
    setSerialReadBufferSize,
    setSerialStopBits,
    setSerialTimeout,
    setSerialWriteBufferSize,
    setSerialWriteMode,
    # setShowExtensionsNotFoundMessages,
    setSimValue,
    setSimValueBoolean,
    setSimValueDouble,
    setSimValueEnum,
    setSimValueInt,
    setSimValueLong,
    setupAnalogGyro,
    shutdown,
    simPeriodicAfter,
    simPeriodicBefore,
    startAddressableLEDOutput,
    startSPIAutoRate,
    startSPIAutoTrigger,
    stopAddressableLEDOutput,
    stopCANPacketRepeating,
    stopNotifier,
    stopSPIAuto,
    tInstances,
    tResourceType,
    transactionI2C,
    transactionSPI,
    updateNotifierAlarm,
    waitForDSData,
    waitForDSDataTimeout,
    waitForInterrupt,
    waitForNotifierAlarm,
    writeAddressableLEDData,
    writeCANPacket,
    writeCANPacketRepeating,
    writeCANRTRFrame,
    writeI2C,
    writeSPI,
    writeSerial,
)

__all__ = [
    "AccelerometerRange",
    "AddressableLEDData",
    "AllianceStationID",
    "AnalogTriggerType",
    "CANDeviceType",
    "CANManufacturer",
    "CANStreamMessage",
    "CAN_CloseStreamSession",
    "CAN_GetCANStatus",
    "CAN_OpenStreamSession",
    "CAN_ReceiveMessage",
    "CAN_SendMessage",
    "ControlWord",
    "CounterMode",
    "EncoderEncodingType",
    "EncoderIndexingType",
    "HandleEnum",
    "I2CPort",
    "JoystickAxes",
    "JoystickButtons",
    "JoystickDescriptor",
    "JoystickPOVs",
    "MatchInfo",
    "MatchType",
    "PowerDistributionFaults",
    "PowerDistributionStickyFaults",
    "PowerDistributionType",
    "PowerDistributionVersion",
    "REVPHCompressorConfig",
    "REVPHCompressorConfigType",
    "REVPHFaults",
    "REVPHStickyFaults",
    "REVPHVersion",
    "RuntimeType",
    "SPIPort",
    "SerialPort",
    "SimBoolean",
    "SimDevice",
    "SimDouble",
    "SimEnum",
    "SimInt",
    "SimLong",
    "SimValue",
    "SimValueDirection",
    "allocateDigitalPWM",
    "calibrateAnalogGyro",
    "cancelNotifierAlarm",
    "checkAnalogInputChannel",
    "checkAnalogModule",
    "checkAnalogOutputChannel",
    "checkCTREPCMSolenoidChannel",
    "checkDIOChannel",
    "checkPWMChannel",
    "checkPowerDistributionChannel",
    "checkPowerDistributionModule",
    "checkREVPHModuleNumber",
    "checkREVPHSolenoidChannel",
    "checkRelayChannel",
    "cleanAnalogTrigger",
    "cleanCAN",
    "cleanInterrupts",
    "cleanNotifier",
    "cleanPowerDistribution",
    "clearAllCTREPCMStickyFaults",
    "clearCounterDownSource",
    "clearCounterUpSource",
    "clearPowerDistributionStickyFaults",
    "clearREVPHStickyFaults",
    "clearSerial",
    "closeI2C",
    "closeSPI",
    "closeSerial",
    "configureSPIAutoStall",
    "createHandle",
    "createPortHandle",
    "createPortHandleForSPI",
    "createSimDevice",
    "createSimValue",
    "createSimValueBoolean",
    "createSimValueDouble",
    "createSimValueEnum",
    "createSimValueInt",
    "createSimValueLong",
    "disableSerialTermination",
    "enableSerialTermination",
    "exitMain",
    "expandFPGATime",
    "fireCTREPCMOneShot",
    "fireREVPHOneShot",
    "flushSerial",
    "forceSPIAutoRead",
    "freeAddressableLED",
    "freeAnalogGyro",
    "freeAnalogInputPort",
    "freeAnalogOutputPort",
    "freeCTREPCM",
    "freeCounter",
    "freeDIOPort",
    "freeDigitalPWM",
    "freeDutyCycle",
    "freeEncoder",
    "freePWMPort",
    "freeREVPH",
    "freeRelayPort",
    "freeSPIAuto",
    "freeSimDevice",
    "getAccelerometerX",
    "getAccelerometerY",
    "getAccelerometerZ",
    "getAccumulatorCount",
    "getAccumulatorOutput",
    "getAccumulatorValue",
    "getAllianceStation",
    "getAnalogAverageBits",
    "getAnalogAverageValue",
    "getAnalogAverageVoltage",
    "getAnalogGyroAngle",
    "getAnalogGyroCenter",
    "getAnalogGyroOffset",
    "getAnalogGyroRate",
    "getAnalogLSBWeight",
    "getAnalogOffset",
    "getAnalogOutput",
    "getAnalogOversampleBits",
    "getAnalogSampleRate",
    "getAnalogTriggerFPGAIndex",
    "getAnalogTriggerInWindow",
    "getAnalogTriggerOutput",
    "getAnalogTriggerTriggerState",
    "getAnalogValue",
    "getAnalogValueToVolts",
    "getAnalogVoltage",
    "getAnalogVoltsToValue",
    "getBrownedOut",
    "getBrownoutVoltage",
    "getCTREPCMClosedLoopControl",
    "getCTREPCMCompressor",
    "getCTREPCMCompressorCurrent",
    "getCTREPCMCompressorCurrentTooHighFault",
    "getCTREPCMCompressorCurrentTooHighStickyFault",
    "getCTREPCMCompressorNotConnectedFault",
    "getCTREPCMCompressorNotConnectedStickyFault",
    "getCTREPCMCompressorShortedFault",
    "getCTREPCMCompressorShortedStickyFault",
    "getCTREPCMPressureSwitch",
    "getCTREPCMSolenoidDisabledList",
    "getCTREPCMSolenoidVoltageFault",
    "getCTREPCMSolenoidVoltageStickyFault",
    "getCTREPCMSolenoids",
    "getControlWord",
    "getCounter",
    "getCounterDirection",
    "getCounterPeriod",
    "getCounterSamplesToAverage",
    "getCounterStopped",
    "getCurrentThreadPriority",
    "getDIO",
    "getDIODirection",
    "getDutyCycleFPGAIndex",
    "getDutyCycleFrequency",
    "getDutyCycleOutput",
    "getDutyCycleOutputRaw",
    "getDutyCycleOutputScaleFactor",
    "getEncoder",
    "getEncoderDecodingScaleFactor",
    "getEncoderDirection",
    "getEncoderDistance",
    "getEncoderDistancePerPulse",
    "getEncoderEncodingScale",
    "getEncoderEncodingType",
    "getEncoderFPGAIndex",
    "getEncoderPeriod",
    "getEncoderRate",
    "getEncoderRaw",
    "getEncoderSamplesToAverage",
    "getEncoderStopped",
    "getErrorMessage",
    "getFPGAButton",
    "getFPGARevision",
    "getFPGATime",
    "getFPGAVersion",
    "getFilterPeriod",
    "getFilterSelect",
    "getHandleIndex",
    "getHandleType",
    "getHandleTypedIndex",
    "getJoystickAxes",
    "getJoystickAxisType",
    "getJoystickButtons",
    "getJoystickDescriptor",
    "getJoystickIsXbox",
    "getJoystickName",
    "getJoystickPOVs",
    "getJoystickType",
    "getLastError",
    "getMatchInfo",
    "getMatchTime",
    "getNumAccumulators",
    "getNumAddressableLEDs",
    "getNumAnalogInputs",
    "getNumAnalogOutputs",
    "getNumAnalogTriggers",
    "getNumCTREPCMModules",
    "getNumCTREPDPChannels",
    "getNumCTREPDPModules",
    "getNumCTRESolenoidChannels",
    "getNumCounters",
    "getNumDigitalChannels",
    "getNumDigitalHeaders",
    "getNumDigitalPWMOutputs",
    "getNumDutyCycles",
    "getNumEncoders",
    "getNumInterrupts",
    "getNumPWMChannels",
    "getNumPWMHeaders",
    "getNumREVPDHChannels",
    "getNumREVPDHModules",
    "getNumREVPHChannels",
    "getNumREVPHModules",
    "getNumRelayChannels",
    "getNumRelayHeaders",
    "getPWMConfigRaw",
    "getPWMCycleStartTime",
    "getPWMEliminateDeadband",
    "getPWMLoopTiming",
    "getPWMPosition",
    "getPWMRaw",
    "getPWMSpeed",
    "getPort",
    "getPortHandleChannel",
    "getPortHandleModule",
    "getPortHandleSPIEnable",
    "getPortWithModule",
    "getPowerDistributionAllChannelCurrents",
    "getPowerDistributionChannelCurrent",
    "getPowerDistributionFaults",
    "getPowerDistributionModuleNumber",
    "getPowerDistributionNumChannels",
    "getPowerDistributionStickyFaults",
    "getPowerDistributionSwitchableChannel",
    "getPowerDistributionTemperature",
    "getPowerDistributionTotalCurrent",
    "getPowerDistributionTotalEnergy",
    "getPowerDistributionTotalPower",
    "getPowerDistributionType",
    "getPowerDistributionVersion",
    "getPowerDistributionVoltage",
    "getREVPH5VVoltage",
    "getREVPHAnalogVoltage",
    "getREVPHCompressor",
    "getREVPHCompressorConfig",
    "getREVPHCompressorCurrent",
    "getREVPHFaults",
    "getREVPHPressureSwitch",
    "getREVPHSolenoidCurrent",
    "getREVPHSolenoidVoltage",
    "getREVPHSolenoids",
    "getREVPHStickyFaults",
    "getREVPHVersion",
    "getREVPHVoltage",
    "getRelay",
    "getRuntimeType",
    "getSPIAutoDroppedCount",
    "getSPIHandle",
    "getSerialBytesReceived",
    "getSerialFD",
    "getSimValue",
    "getSimValueBoolean",
    "getSimValueDouble",
    "getSimValueEnum",
    "getSimValueInt",
    "getSimValueLong",
    "getSystemActive",
    "getSystemClockTicksPerMicrosecond",
    "getUserActive3V3",
    "getUserActive5V",
    "getUserActive6V",
    "getUserCurrent3V3",
    "getUserCurrent5V",
    "getUserCurrent6V",
    "getUserCurrentFaults3V3",
    "getUserCurrentFaults5V",
    "getUserCurrentFaults6V",
    "getUserVoltage3V3",
    "getUserVoltage5V",
    "getUserVoltage6V",
    "getVinCurrent",
    "getVinVoltage",
    "hasMain",
    "initAccumulator",
    "initSPIAuto",
    "initialize",
    "initializeAddressableLED",
    "initializeAnalogGyro",
    "initializeAnalogInputPort",
    "initializeAnalogOutputPort",
    "initializeAnalogTrigger",
    "initializeAnalogTriggerDutyCycle",
    "initializeCAN",
    "initializeCTREPCM",
    "initializeCounter",
    "initializeDIOPort",
    "initializeDriverStation",
    "initializeDutyCycle",
    "initializeEncoder",
    "initializeI2C",
    "initializeInterrupts",
    "initializeNotifier",
    "initializePWMPort",
    "initializePowerDistribution",
    "initializeREVPH",
    "initializeRelayPort",
    "initializeSPI",
    "initializeSerialPort",
    "initializeSerialPortDirect",
    "isAccumulatorChannel",
    "isAnyPulsing",
    "isHandleCorrectVersion",
    "isHandleType",
    "isNewControlData",
    "isPulsing",
    "latchPWMZero",
    # "loadExtensions",
    # "loadOneExtension",
    "observeUserProgramAutonomous",
    "observeUserProgramDisabled",
    "observeUserProgramStarting",
    "observeUserProgramTeleop",
    "observeUserProgramTest",
    "pulse",
    "readCANPacketLatest",
    "readCANPacketNew",
    "readCANPacketTimeout",
    "readI2C",
    "readInterruptFallingTimestamp",
    "readInterruptRisingTimestamp",
    "readSPI",
    "readSPIAutoReceivedData",
    "readSerial",
    "releaseDSMutex",
    "releaseWaitingInterrupt",
    "report",
    "requestInterrupts",
    "resetAccumulator",
    "resetAnalogGyro",
    "resetCounter",
    "resetEncoder",
    "resetPowerDistributionTotalEnergy",
    "resetSimValue",
    "runMain",
    "sendConsoleLine",
    "sendError",
    "setAccelerometerActive",
    "setAccelerometerRange",
    "setAccumulatorCenter",
    "setAccumulatorDeadband",
    "setAddressableLEDBitTiming",
    "setAddressableLEDLength",
    "setAddressableLEDOutputPort",
    "setAddressableLEDSyncTime",
    "setAnalogAverageBits",
    "setAnalogGyroDeadband",
    "setAnalogGyroParameters",
    "setAnalogGyroVoltsPerDegreePerSecond",
    "setAnalogInputSimDevice",
    "setAnalogOutput",
    "setAnalogOversampleBits",
    "setAnalogSampleRate",
    "setAnalogTriggerAveraged",
    "setAnalogTriggerFiltered",
    "setAnalogTriggerLimitsDutyCycle",
    "setAnalogTriggerLimitsRaw",
    "setAnalogTriggerLimitsVoltage",
    "setBrownoutVoltage",
    "setCTREPCMClosedLoopControl",
    "setCTREPCMOneShotDuration",
    "setCTREPCMSolenoids",
    "setCounterAverageSize",
    "setCounterDownSource",
    "setCounterDownSourceEdge",
    "setCounterExternalDirectionMode",
    "setCounterMaxPeriod",
    "setCounterPulseLengthMode",
    "setCounterReverseDirection",
    "setCounterSamplesToAverage",
    "setCounterSemiPeriodMode",
    "setCounterUpDownMode",
    "setCounterUpSource",
    "setCounterUpSourceEdge",
    "setCounterUpdateWhenEmpty",
    "setCurrentThreadPriority",
    "setDIO",
    "setDIODirection",
    "setDIOSimDevice",
    "setDigitalPWMDutyCycle",
    "setDigitalPWMOutputChannel",
    "setDigitalPWMRate",
    # "setDutyCycleSimDevice",
    "setEncoderDistancePerPulse",
    "setEncoderIndexSource",
    "setEncoderMaxPeriod",
    "setEncoderMinRate",
    "setEncoderReverseDirection",
    "setEncoderSamplesToAverage",
    "setEncoderSimDevice",
    "setFilterPeriod",
    "setFilterSelect",
    "setInterruptUpSourceEdge",
    "setJoystickOutputs",
    "setNotifierName",
    "setNotifierThreadPriority",
    "setPWMConfig",
    "setPWMConfigRaw",
    "setPWMDisabled",
    "setPWMEliminateDeadband",
    "setPWMPeriodScale",
    "setPWMPosition",
    "setPWMRaw",
    "setPWMSpeed",
    "setPowerDistributionSwitchableChannel",
    "setREVPHClosedLoopControlAnalog",
    "setREVPHClosedLoopControlDigital",
    "setREVPHClosedLoopControlDisabled",
    "setREVPHClosedLoopControlHybrid",
    "setREVPHCompressorConfig",
    "setREVPHSolenoids",
    "setRelay",
    "setSPIAutoTransmitData",
    "setSPIChipSelectActiveHigh",
    "setSPIChipSelectActiveLow",
    "setSPIHandle",
    "setSPIOpts",
    "setSPISpeed",
    "setSerialBaudRate",
    "setSerialDataBits",
    "setSerialFlowControl",
    "setSerialParity",
    "setSerialReadBufferSize",
    "setSerialStopBits",
    "setSerialTimeout",
    "setSerialWriteBufferSize",
    "setSerialWriteMode",
    # "setShowExtensionsNotFoundMessages",
    "setSimValue",
    "setSimValueBoolean",
    "setSimValueDouble",
    "setSimValueEnum",
    "setSimValueInt",
    "setSimValueLong",
    "setupAnalogGyro",
    "shutdown",
    "simPeriodicAfter",
    "simPeriodicBefore",
    "startAddressableLEDOutput",
    "startSPIAutoRate",
    "startSPIAutoTrigger",
    "stopAddressableLEDOutput",
    "stopCANPacketRepeating",
    "stopNotifier",
    "stopSPIAuto",
    "tInstances",
    "tResourceType",
    "transactionI2C",
    "transactionSPI",
    "updateNotifierAlarm",
    "waitForDSData",
    "waitForDSDataTimeout",
    "waitForInterrupt",
    "waitForNotifierAlarm",
    "writeAddressableLEDData",
    "writeCANPacket",
    "writeCANPacketRepeating",
    "writeCANRTRFrame",
    "writeI2C",
    "writeSPI",
    "writeSerial",
]


from ._wpiHal import __hal_simulation__

if __hal_simulation__:
    from ._wpiHal import (
        loadExtensions,
        loadOneExtension,
        setDutyCycleSimDevice,
        setShowExtensionsNotFoundMessages,
    )

    __all__ += [
        "loadExtensions",
        "loadOneExtension",
        "setDutyCycleSimDevice",
        "setShowExtensionsNotFoundMessages",
    ]

try:
    from ._wpiHal import SerialHelper

    __all__ += ["SerialHelper"]
except ImportError:
    pass
