"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SmithyBuild = void 0;
const component_1 = require("../component");
const json_1 = require("../json");
/**
 * Smithy build configuration options
 */
class SmithyBuild extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this.version = options.version ?? "1.0";
        this.outputDirectory = options.outputDirectory;
        this._imports = options.imports;
        this._projections = options.projections;
        this._plugins = options.plugins;
        this.ignoreMissingPlugins = options.ignoreMissingPlugins;
        this.manifest = {
            version: this.version,
            outputDirectory: this.outputDirectory,
            imports: () => this._imports,
            projections: () => this._projections,
            plugins: () => this._plugins,
            ignoreMissingPlugins: this.ignoreMissingPlugins,
        };
        new json_1.JsonFile(this.project, "smithy-build.json", {
            obj: this.manifest,
            readonly: true,
            newline: false,
        });
    }
    /**
     * Get configured projections
     */
    get projections() {
        return this._projections ? { ...this._projections } : undefined;
    }
    /**
     * Get configured imports
     */
    get imports() {
        return this._imports ? [...this._imports] : undefined;
    }
    /**
     * Get configured plugins
     */
    get plugins() {
        return this._plugins ? { ...this._plugins } : undefined;
    }
    /**
     * Add a smithy build import
     */
    addImport(imp) {
        this._imports ? this._imports.push(imp) : (this._imports = [`${imp}`]);
    }
    /**
     * Add smithy build projections
     */
    addProjections(projections) {
        for (const [k, v] of Object.entries(projections)) {
            this._projections
                ? (this._projections[k] = v)
                : (this._projections = { [k]: v });
        }
    }
    /**
     * Add smithy build plugins
     */
    addPlugins(plugins) {
        for (const [k, v] of Object.entries(plugins)) {
            this._plugins ? (this._plugins[k] = v) : (this._plugins = { [k]: v });
        }
    }
}
exports.SmithyBuild = SmithyBuild;
//# sourceMappingURL=data:application/json;base64,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