"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Renovatebot = exports.RenovatebotScheduleInterval = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("./component");
const json_1 = require("./json");
/**
 * How often to check for new versions and raise pull requests for version
 * updates.
 *
 * @see https://docs.renovatebot.com/presets-schedule/
 */
var RenovatebotScheduleInterval;
(function (RenovatebotScheduleInterval) {
    /**
     * Run at any time
     */
    RenovatebotScheduleInterval["ANY_TIME"] = "at any time";
    /**
     * Weekly schedule on early monday mornings
     */
    RenovatebotScheduleInterval["EARLY_MONDAYS"] = "before 3am on Monday";
    /**
     * Schedule daily
     */
    RenovatebotScheduleInterval["DAILY"] = "before 2am";
    /**
     * Schedule weekly
     */
    RenovatebotScheduleInterval["WEEKLY"] = "before 3am on Monday";
    /**
     * Schedule monthly
     */
    RenovatebotScheduleInterval["MONTHLY"] = "before 3am on the first day of the month";
    /**
     * Schedule quarterly
     */
    RenovatebotScheduleInterval["QUARTERLY"] = "every 3 months on the first day of the month";
    /**
     * Schedule for weekends
     */
    RenovatebotScheduleInterval["WEEKENDS"] = "every weekend";
    /**
     * Schedule for weekdays
     */
    RenovatebotScheduleInterval["WEEKDAYS"] = "every weekday";
})(RenovatebotScheduleInterval = exports.RenovatebotScheduleInterval || (exports.RenovatebotScheduleInterval = {}));
/**
 * Defines renovatebot configuration for projen project.
 *
 * Ignores the versions controlled by Projen.
 */
class Renovatebot extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this._project = project;
        this.explicitIgnores = options.ignore ?? [];
        this.labels = options.labels;
        this.scheduleInterval = options.scheduleInterval ?? [
            RenovatebotScheduleInterval.ANY_TIME,
        ];
        (options.ignoreProjen ?? true) && this.explicitIgnores.push("projen");
    }
    // create actual file only here, so we know that all dependencies are added to the project
    preSynthesize() {
        this.createRenovateConfiguration();
    }
    createRenovateConfiguration() {
        const renovateIgnore = [
            ...new Set(this._project.deps.all
                .filter((dep) => dep.version)
                .map((dep) => dep.name)
                .concat(this.explicitIgnores)),
        ];
        const config = {
            labels: this.labels,
            schedule: this.scheduleInterval,
            extends: [
                ":preserveSemverRanges",
                "config:base",
                "group:allNonMajor",
                "group:recommended",
                "group:monorepos",
            ],
            packageRules: [
                {
                    matchDepTypes: ["devDependencies"],
                    matchUpdateTypes: ["patch", "minor"],
                    groupName: "devDependencies (non-major)",
                },
            ],
            ignoreDeps: renovateIgnore,
        };
        new json_1.JsonFile(this._project, "renovate.json5", {
            obj: config,
            committed: true,
        });
    }
}
exports.Renovatebot = Renovatebot;
_a = JSII_RTTI_SYMBOL_1;
Renovatebot[_a] = { fqn: "projen.Renovatebot", version: "0.60.2" };
//# sourceMappingURL=data:application/json;base64,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