"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequirementsFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const dependencies_1 = require("../dependencies");
const file_1 = require("../file");
const semver_1 = require("../util/semver");
/**
 * Specifies a list of packages to be installed using pip.
 *
 * @see https://pip.pypa.io/en/stable/reference/pip_install/#requirements-file-format
 */
class RequirementsFile extends file_1.FileBase {
    constructor(project, filePath, options) {
        super(project, filePath);
        this.packages = new Array();
        this.packageProvider = options.packageProvider;
    }
    /**
     * Adds the specified packages provided in semver format.
     *
     * Comment lines (start with `#`) are ignored.
     *
     * @param packages Package version in format `<module>@<semver>`
     */
    addPackages(...packages) {
        for (let pkg of packages) {
            if (pkg.startsWith("#")) {
                this.packages.push(pkg);
            }
            else {
                const { name, version } = dependencies_1.Dependencies.parseDependency(pkg);
                if (version) {
                    this.packages.push(`${name}${semver_1.toPythonVersionRange(version)}`);
                }
                else {
                    this.packages.push(name);
                }
            }
        }
    }
    formatDependency(dep) {
        if (dep.version) {
            return `${dep.name}${semver_1.toPythonVersionRange(dep.version)}`;
        }
        else {
            return dep.name;
        }
    }
    synthesizeContent(resolver) {
        const allPackages = [...this.packages];
        if (this.packageProvider) {
            allPackages.push(...this.packageProvider.packages.map((dep) => this.formatDependency(dep)));
        }
        return `${resolver
            .resolve([...(this.marker ? [`# ${this.marker}`] : []), ...allPackages])
            .join("\n")}\n`;
    }
}
exports.RequirementsFile = RequirementsFile;
_a = JSII_RTTI_SYMBOL_1;
RequirementsFile[_a] = { fqn: "projen.python.RequirementsFile", version: "0.60.2" };
//# sourceMappingURL=data:application/json;base64,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