"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const object_file_1 = require("./object-file");
/**
 * Represents a JSON file.
 */
class JsonFile extends object_file_1.ObjectFile {
    constructor(project, filePath, options) {
        super(project, filePath, options);
        this.newline = options.newline ?? true;
        this.isJson5 = filePath.toLowerCase().endsWith("json5");
        if (!options.obj) {
            throw new Error('"obj" cannot be undefined');
        }
    }
    synthesizeContent(resolver) {
        const json = super.synthesizeContent(resolver);
        if (!json) {
            return undefined;
        }
        const sanitized = JSON.parse(json);
        if (this.marker && !this.isJson5) {
            sanitized["//"] = this.marker;
        }
        let content = JSON.stringify(sanitized, undefined, 2);
        if (this.marker && this.isJson5) {
            content = content.slice(0, -1) + `// ${this.marker}\n}`;
        }
        if (this.newline) {
            content += "\n";
        }
        return content;
    }
}
exports.JsonFile = JsonFile;
_a = JSII_RTTI_SYMBOL_1;
JsonFile[_a] = { fqn: "projen.JsonFile", version: "0.60.2" };
//# sourceMappingURL=data:application/json;base64,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