import { IResolver } from "./file";
import { ObjectFile, ObjectFileOptions } from "./object-file";
import { Project } from "./project";
/**
 * Options for `JsonFile`.
 */
export interface JsonFileOptions extends ObjectFileOptions {
    /**
     * Adds a newline at the end of the file.
     * @default true
     */
    readonly newline?: boolean;
}
/**
 * Represents a JSON file.
 */
export declare class JsonFile extends ObjectFile {
    private readonly newline;
    private readonly isJson5;
    constructor(project: Project, filePath: string, options: JsonFileOptions);
    protected synthesizeContent(resolver: IResolver): string | undefined;
}
