import { FileBase, IResolver } from "./file";
import { Project } from "./project";
export declare class IgnoreFile extends FileBase {
    private readonly _patterns;
    constructor(project: Project, filePath: string);
    /**
     * Add ignore patterns. Files that match this pattern will be ignored. If the
     * pattern starts with a negation mark `!`, files that match will _not_ be
     * ignored.
     *
     * Comment lines (start with `#`) are ignored.
     *
     * @param patterns Ignore patterns.
     */
    addPatterns(...patterns: string[]): void;
    private normalizePatterns;
    /**
     * Removes patterns previously added from the ignore file.
     *
     * If `addPattern()` is called after this, the pattern will be added again.
     *
     * @param patterns patters to remove.
     */
    removePatterns(...patterns: string[]): void;
    /**
     * Ignore the files that match these patterns.
     * @param patterns The patterns to match.
     */
    exclude(...patterns: string[]): void;
    /**
     * Always include the specified file patterns.
     * @param patterns Patterns to include in git commits.
     */
    include(...patterns: string[]): void;
    protected synthesizeContent(resolver: IResolver): string | undefined;
}
