import { Component } from "../component";
import { YamlFile } from "../yaml";
import { GitHub } from "./github";
import { GithubCredentials } from "./github-credentials";
import * as workflows from "./workflows-model";
/**
 * Options for `GithubWorkflow`.
 */
export interface GithubWorkflowOptions {
    /**
     * Force the creation of the workflow even if `workflows` is disabled in `GitHub`.
     *
     * @default false
     */
    readonly force?: boolean;
    /**
     * Concurrency ensures that only a single job or workflow using the same concurrency group will run at a time. Currently in beta.
     *
     * @default - disabled
     * @see https://docs.github.com/en/actions/learn-github-actions/workflow-syntax-for-github-actions#concurrency
     */
    readonly concurrency?: string;
}
/**
 * Workflow for GitHub.
 *
 * A workflow is a configurable automated process made up of one or more jobs.
 *
 * @see https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions
 */
export declare class GithubWorkflow extends Component {
    /**
     * The name of the workflow.
     */
    readonly name: string;
    /**
     * Concurrency ensures that only a single job or workflow using the same concurrency group will run at a time.
     *
     * @default disabled
     * @experimental
     */
    readonly concurrency?: string;
    /**
     * The workflow YAML file. May not exist if `workflowsEnabled` is false on `GitHub`.
     */
    readonly file: YamlFile | undefined;
    /**
     * GitHub API authentication method used by projen workflows.
     */
    readonly projenCredentials: GithubCredentials;
    private events;
    private jobs;
    constructor(github: GitHub, name: string, options?: GithubWorkflowOptions);
    /**
     * Add events to triggers the workflow.
     *
     * @param events The event(s) to trigger the workflow.
     */
    on(events: workflows.Triggers): void;
    /**
     * Adds a single job to the workflow.
     * @param id The job name (unique within the workflow)
     * @param job The job specification
     */
    addJob(id: string, job: workflows.Job | workflows.JobCallingReusableWorkflow): void;
    /**
     * Add jobs to the workflow.
     *
     * @param jobs Jobs to add.
     */
    addJobs(jobs: Record<string, workflows.Job | workflows.JobCallingReusableWorkflow>): void;
    private renderWorkflow;
}
export interface IJobProvider {
    /**
     * Generates a collection of named GitHub workflow jobs.
     */
    renderJobs(): Record<string, workflows.Job>;
}
