"use strict";
// @see https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobPermission = void 0;
/**
 * Access level for workflow permission scopes.
 */
var JobPermission;
(function (JobPermission) {
    /** Read-only access */
    JobPermission["READ"] = "read";
    /** Read-write access */
    JobPermission["WRITE"] = "write";
    /** No access at all */
    JobPermission["NONE"] = "none";
})(JobPermission = exports.JobPermission || (exports.JobPermission = {}));
//#endregion
//# sourceMappingURL=data:application/json;base64,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