"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
const dependabot_1 = require("./dependabot");
const github_credentials_1 = require("./github-credentials");
const mergify_1 = require("./mergify");
const pr_template_1 = require("./pr-template");
const pull_request_lint_1 = require("./pull-request-lint");
const workflows_1 = require("./workflows");
class GitHub extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this.workflowsEnabled = options.workflows ?? true;
        if (options.projenCredentials && options.projenTokenSecret) {
            throw new Error("projenTokenSecret is deprecated, please use projenCredentials instead");
        }
        if (options.projenTokenSecret) {
            this.projenCredentials = github_credentials_1.GithubCredentials.fromPersonalAccessToken({
                secret: options.projenTokenSecret,
            });
        }
        else if (options.projenCredentials) {
            this.projenCredentials = options.projenCredentials;
        }
        else {
            this.projenCredentials = github_credentials_1.GithubCredentials.fromPersonalAccessToken({
                secret: "PROJEN_GITHUB_TOKEN",
            });
        }
        if (options.mergify ?? true) {
            this.mergify = new mergify_1.Mergify(this, options.mergifyOptions);
        }
        if (options.pullRequestLint ?? true) {
            new pull_request_lint_1.PullRequestLint(this, options.pullRequestLintOptions);
        }
    }
    /**
     * Returns the `GitHub` component of a project or `undefined` if the project
     * does not have a GitHub component.
     */
    static of(project) {
        const isGitHub = (c) => c instanceof GitHub;
        return project.components.find(isGitHub);
    }
    /**
     * All workflows.
     */
    get workflows() {
        const isWorkflow = (c) => c instanceof workflows_1.GithubWorkflow;
        return this.project.components
            .filter(isWorkflow)
            .sort((w1, w2) => w1.name.localeCompare(w2.name));
    }
    /**
     * Adds a workflow to the project.
     * @param name Name of the workflow
     * @returns a GithubWorkflow instance
     */
    addWorkflow(name) {
        const workflow = new workflows_1.GithubWorkflow(this, name);
        return workflow;
    }
    addPullRequestTemplate(...content) {
        return new pr_template_1.PullRequestTemplate(this, { lines: content });
    }
    addDependabot(options) {
        return new dependabot_1.Dependabot(this, options);
    }
    /**
     * Finds a GitHub workflow by name. Returns `undefined` if the workflow cannot be found.
     * @param name The name of the GitHub workflow
     */
    tryFindWorkflow(name) {
        return this.workflows.find((w) => w.name === name);
    }
}
exports.GitHub = GitHub;
_a = JSII_RTTI_SYMBOL_1;
GitHub[_a] = { fqn: "projen.github.GitHub", version: "0.60.2" };
//# sourceMappingURL=data:application/json;base64,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