import { ConstructLibrary, ConstructLibraryOptions } from "../cdk";
export interface ConstructLibraryCdktfOptions extends ConstructLibraryOptions {
    /**
     * Minimum target version this library is tested against.
     * @default "^0.8.3"
     * @featured
     */
    readonly cdktfVersion: string;
    /**
     * Construct version to use
     * @default "^10.0.12"
     */
    readonly constructsVersion?: string;
}
/**
 * CDKTF construct library project
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the CDK for Terraform (CDKTF), with a friendly workflow and
 * automatic publishing to the construct catalog.
 *
 * @pjid cdktf-construct
 */
export declare class ConstructLibraryCdktf extends ConstructLibrary {
    constructor(options: ConstructLibraryCdktfOptions);
}
