"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTestAutoDiscover = exports.AutoDiscover = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_1 = require("../cdk");
const component_1 = require("../component");
const integration_test_1 = require("./integration-test");
/**
 * Automatically discovers and creates `IntegrationTest`s from entry points
 * found in the test tree.
 */
class AutoDiscover extends component_1.Component {
    constructor(project, options) {
        super(project);
        if (options.integrationTestAutoDiscover ?? true) {
            new IntegrationTestAutoDiscover(this.project, options);
        }
    }
}
exports.AutoDiscover = AutoDiscover;
_a = JSII_RTTI_SYMBOL_1;
AutoDiscover[_a] = { fqn: "projen.cdk8s.AutoDiscover", version: "0.60.2" };
/**
 * Discovers and creates integration tests from files in the test root.
 */
class IntegrationTestAutoDiscover extends cdk_1.IntegrationTestAutoDiscoverBase {
    constructor(project, options) {
        super(project, options);
        for (const entrypoint of this.entrypoints) {
            new integration_test_1.IntegrationTest(this.project, {
                entrypoint,
                tsconfigPath: options.tsconfigPath,
            });
        }
    }
}
exports.IntegrationTestAutoDiscover = IntegrationTestAutoDiscover;
_b = JSII_RTTI_SYMBOL_1;
IntegrationTestAutoDiscover[_b] = { fqn: "projen.cdk8s.IntegrationTestAutoDiscover", version: "0.60.2" };
//# sourceMappingURL=data:application/json;base64,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