"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsiiDocgen = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Creates a markdown file based on the jsii manifest:
 * - Adds a `docgen` script to package.json
 * - Runs `jsii-docgen` after compilation
 * - Enforces that markdown file is checked in
 */
class JsiiDocgen {
    constructor(project, options = {}) {
        project.addDevDeps("jsii-docgen");
        const filePath = options.filePath ?? "API.md";
        const docgen = project.addTask("docgen", {
            description: "Generate API.md from .jsii manifest",
            exec: `jsii-docgen -o ${filePath}`,
        });
        // spawn docgen after compilation (requires the .jsii manifest).
        project.postCompileTask.spawn(docgen);
        project.gitignore.include(`/${filePath}`);
    }
}
exports.JsiiDocgen = JsiiDocgen;
_a = JSII_RTTI_SYMBOL_1;
JsiiDocgen[_a] = { fqn: "projen.cdk.JsiiDocgen", version: "0.60.2" };
//# sourceMappingURL=data:application/json;base64,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