import { JsiiProject } from "./jsii-project";
/**
 * Options for `JsiiDocgen`
 */
export interface JsiiDocgenOptions {
    /**
     * File path for generated docs.
     * @default "API.md"
     */
    readonly filePath?: string;
}
/**
 * Creates a markdown file based on the jsii manifest:
 * - Adds a `docgen` script to package.json
 * - Runs `jsii-docgen` after compilation
 * - Enforces that markdown file is checked in
 */
export declare class JsiiDocgen {
    constructor(project: JsiiProject, options?: JsiiDocgenOptions);
}
