"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTest = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const cdk_1 = require("../cdk");
const dependencies_1 = require("../dependencies");
const internal_1 = require("./internal");
/**
 * Cloud integration tests.
 */
class IntegrationTest extends cdk_1.IntegrationTestBase {
    constructor(project, options) {
        super(project, options);
        if (!project.deps.tryGetDependency("aws-cdk")) {
            project.deps.addDependency(`aws-cdk@^${options.cdkDeps.cdkMajorVersion}`, dependencies_1.DependencyType.BUILD);
        }
        if (!project.deps.tryGetDependency("ts-node")) {
            project.deps.addDependency("ts-node", dependencies_1.DependencyType.BUILD);
        }
        const deployDir = path_1.join(this.tmpDir, "deploy.cdk.out");
        const assertDir = path_1.join(this.tmpDir, "assert.cdk.out");
        const app = `ts-node -P ${options.tsconfigPath} ${options.entrypoint}`;
        const opts = [
            `--app "${app}"`,
            "--no-version-reporting",
            // don't inject cloudformation metadata into template
            "--no-asset-metadata",
        ];
        const pathMetadata = options.pathMetadata ?? false;
        if (!pathMetadata) {
            opts.push("--no-path-metadata");
        }
        if (options.cdkDeps.cdkMajorVersion === 1) {
            // add all feature flags
            const features = [
                ...internal_1.FEATURE_FLAGS,
                "@aws-cdk/core:newStyleStackSynthesis",
            ];
            for (const feature of features) {
                opts.push(`--context ${feature}=true`);
            }
        }
        const cdkopts = opts.join(" ");
        // Determine which stacks to deploy
        const stacks = options.stacks ?? ["**"];
        const stackOpts = stacks.map((stack) => `'${stack}'`).join(" ");
        this.deployTask.exec(`rm -fr ${deployDir}`);
        this.deployTask.exec(`cdk deploy ${cdkopts} ${stackOpts} --require-approval=never -o ${deployDir}`);
        // if deployment was successful, copy the deploy dir to the expected dir
        this.deployTask.exec(`rm -fr ${this.snapshotDir}`);
        this.deployTask.exec(`mv ${deployDir} ${this.snapshotDir}`);
        this.watchTask = project.addTask(`integ:${this.name}:watch`, {
            description: `watch integration test '${this.name}' (without updating snapshots)`,
            exec: `cdk watch ${cdkopts} ${stackOpts} -o ${deployDir}`,
        });
        this.destroyTask = project.addTask(`integ:${this.name}:destroy`, {
            description: `destroy integration test '${this.name}'`,
            exec: `cdk destroy --app ${this.snapshotDir} ${stackOpts} --no-version-reporting`,
        });
        const destroyAfterDeploy = options.destroyAfterDeploy ?? true;
        if (destroyAfterDeploy) {
            this.deployTask.spawn(this.destroyTask);
        }
        this.snapshotTask.exec(`cdk synth ${cdkopts} -o ${this.snapshotDir} > /dev/null`);
        const exclude = ["asset.*", "cdk.out", "manifest.json", "tree.json"];
        this.assertTask.exec(`cdk synth ${cdkopts} -o ${assertDir} > /dev/null`);
        this.assertTask.exec(`diff -r ${exclude.map((x) => `-x ${x}`).join(" ")} ${this.snapshotDir}/ ${assertDir}/`);
        // do not commit all files we are excluding
        for (const x of exclude) {
            project.addGitIgnore(`${this.snapshotDir}/${x}`);
            project.addGitIgnore(`${this.snapshotDir}/**/${x}`); // nested assemblies
        }
    }
}
exports.IntegrationTest = IntegrationTest;
_a = JSII_RTTI_SYMBOL_1;
IntegrationTest[_a] = { fqn: "projen.awscdk.IntegrationTest", version: "0.60.2" };
//# sourceMappingURL=data:application/json;base64,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