"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CdkTasks = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * Adds standard AWS CDK tasks to your project.
 */
class CdkTasks extends component_1.Component {
    constructor(project) {
        super(project);
        this.synth = project.addTask("synth", {
            description: "Synthesizes your cdk app into cdk.out",
            exec: "cdk synth",
        });
        this.synthSilent = project.addTask("synth:silent", {
            description: 'Synthesizes your cdk app into cdk.out and suppresses the template in stdout (part of "yarn build")',
            exec: "cdk synth -q",
        });
        this.deploy = project.addTask("deploy", {
            description: "Deploys your CDK app to the AWS cloud",
            exec: "cdk deploy",
        });
        this.destroy = project.addTask("destroy", {
            description: "Destroys your cdk app in the AWS cloud",
            exec: "cdk destroy",
        });
        this.diff = project.addTask("diff", {
            description: "Diffs the currently deployed app against your code",
            exec: "cdk diff",
        });
        // typescript projects already have a "watch" task, we we will repurpose it
        const watch = project.tasks.tryFind("watch") ?? project.addTask("watch");
        watch.reset();
        watch.description =
            "Watches changes in your source code and rebuilds and deploys to the current account";
        // deploy first because surprisingly watch is not deploying first
        // see https://github.com/aws/aws-cdk/issues/17776
        watch.exec("cdk deploy --hotswap");
        // now we are ready to watch
        watch.exec("cdk watch");
        this.watch = watch;
    }
}
exports.CdkTasks = CdkTasks;
_a = JSII_RTTI_SYMBOL_1;
CdkTasks[_a] = { fqn: "projen.awscdk.CdkTasks", version: "0.60.2" };
//# sourceMappingURL=data:application/json;base64,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