"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsCdkPythonApp = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _1 = require(".");
const __1 = require("..");
const python_1 = require("../python");
const sample_file_1 = require("../sample-file");
const awscdk_deps_py_1 = require("./awscdk-deps-py");
const awscdk_pytest_sample_1 = require("./awscdk-pytest-sample");
/**
 * AWS CDK app in Python
 *
 * @pjid awscdk-app-py
 */
class AwsCdkPythonApp extends python_1.PythonProject {
    constructor(options) {
        super({ ...options, pytest: false, sample: false });
        this.cdkDeps = new awscdk_deps_py_1.AwsCdkDepsPy(this, {
            dependencyType: __1.DependencyType.RUNTIME,
            ...options,
        });
        this.appEntrypoint = options.appEntrypoint ?? "app.py";
        this.testdir = options.testdir ?? "tests";
        this.cdkTasks = new _1.CdkTasks(this);
        this.postCompileTask.spawn(this.cdkTasks.synthSilent);
        this.cdkConfig = new _1.CdkConfig(this, {
            app: `python ${this.appEntrypoint}`,
            featureFlags: this.cdkDeps.cdkMajorVersion < 2,
            watchIncludes: ["**"],
            watchExcludes: [
                "README.md",
                "cdk*.json",
                "requirements*.txt",
                "source.bat",
                "**/__init__.py",
                "python/__pycache__",
                "tests",
            ],
            ...options,
        });
        if (options.sample ?? true) {
            new AppCode(this, "app.py", this.cdkDeps.cdkMajorVersion);
            new MyStackCode(this, this.moduleName, this.cdkDeps.cdkMajorVersion);
        }
        if (options.pytest ?? true) {
            this.pytest = new python_1.Pytest(this, options.pytestOptions);
            new awscdk_pytest_sample_1.AwsCdkPytestSample(this, this.pytest.testdir);
        }
    }
    /**
     * The CDK version this app is using.
     */
    get cdkVersion() {
        return this.cdkDeps.cdkVersion;
    }
}
exports.AwsCdkPythonApp = AwsCdkPythonApp;
_a = JSII_RTTI_SYMBOL_1;
AwsCdkPythonApp[_a] = { fqn: "projen.awscdk.AwsCdkPythonApp", version: "0.60.2" };
class AppCode extends __1.Component {
    constructor(project, fileName, cdkVersion) {
        super(project);
        let versionImport;
        if (cdkVersion < 2) {
            versionImport = "from aws_cdk.core import App, Environment";
        }
        else {
            versionImport = "from aws_cdk import App, Environment";
        }
        new sample_file_1.SampleFile(project, fileName, {
            contents: [
                "import os",
                versionImport,
                `from ${project.moduleName}.main import MyStack`,
                "",
                "# for development, use account/region from cdk cli",
                "dev_env = Environment(",
                "  account=os.getenv('CDK_DEFAULT_ACCOUNT'),",
                "  region=os.getenv('CDK_DEFAULT_REGION')",
                ")",
                "",
                "app = App()",
                `MyStack(app, "${this.project.name}-dev", env=dev_env)`,
                `# MyStack(app, "${this.project.name}-prod", env=prod_env)`,
                "",
                "app.synth()",
            ].join("\n"),
        });
    }
}
class MyStackCode extends __1.Component {
    constructor(project, dir, cdkMajorVersion) {
        super(project);
        let appFile = [];
        appFile.push("import os");
        if (cdkMajorVersion < 2) {
            appFile.push("from aws_cdk.core import Construct, Stack");
        }
        else {
            appFile.push("from aws_cdk import Stack");
            appFile.push("from constructs import Construct");
        }
        appFile.push("");
        appFile.push("");
        appFile.push("class MyStack(Stack):");
        appFile.push("  def __init__(self, scope: Construct, construct_id: str, **kwargs) -> None:");
        appFile.push("    super().__init__(scope, construct_id, **kwargs)");
        appFile.push("");
        appFile.push("    # The code that defines your stack goes here");
        appFile.push("");
        new __1.SampleDir(project, dir, {
            files: {
                "__init__.py": "",
                "main.py": appFile.join("\n"),
            },
        });
    }
}
//# sourceMappingURL=data:application/json;base64,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