"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TextFile = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const file_1 = require("./file");
/**
 * A text file.
 */
class TextFile extends file_1.FileBase {
    /**
     * Defines a text file.
     *
     * @param project The project
     * @param filePath File path
     * @param options Options
     */
    constructor(project, filePath, options = {}) {
        super(project, filePath, options);
        this.lines = options.lines ?? [];
    }
    /**
     * Adds a line to the text file.
     * @param line the line to add (can use tokens)
     */
    addLine(line) {
        this.lines.push(line);
    }
    synthesizeContent(_) {
        return this.lines.join("\n");
    }
}
exports.TextFile = TextFile;
_a = JSII_RTTI_SYMBOL_1;
TextFile[_a] = { fqn: "projen.TextFile", version: "0.65.76" };
//# sourceMappingURL=data:application/json;base64,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