"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Projenrc = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const fs_extra_1 = require("fs-extra");
const component_1 = require("./component");
/**
 * Sets up a project to use JSON for projenrc.
 */
class Projenrc extends component_1.Component {
    constructor(project, options = {}) {
        super(project);
        this.rcfile = options.filename ?? ".projenrc.json";
        // this is the task projen executes when running `projen`
        project.defaultTask?.env("FILENAME", this.rcfile);
        project.defaultTask?.builtin("run-projenrc-json");
        this.generateProjenrc();
    }
    generateProjenrc() {
        const rcfile = path_1.resolve(this.project.outdir, this.rcfile);
        if (fs_extra_1.existsSync(rcfile)) {
            return; // already exists
        }
        const bootstrap = this.project.initProject;
        if (!bootstrap) {
            return;
        }
        const json = {
            type: bootstrap.fqn,
            ...bootstrap.args,
        };
        fs_extra_1.outputFileSync(rcfile, JSON.stringify(json, null, 2));
        this.project.logger.info(`Project definition file was created at ${rcfile}`);
    }
}
exports.Projenrc = Projenrc;
_a = JSII_RTTI_SYMBOL_1;
Projenrc[_a] = { fqn: "projen.Projenrc", version: "0.65.76" };
//# sourceMappingURL=data:application/json;base64,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