"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Junit = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const component_1 = require("../component");
const sample_file_1 = require("../sample-file");
const TESTDIR = path_1.join("src", "test", "java");
/**
 * Implements JUnit-based testing.
 */
class Junit extends component_1.Component {
    constructor(project, options) {
        super(project);
        const pom = options.pom;
        const version = options.version ?? "5.7.0";
        pom.addTestDependency(`org.junit.jupiter/junit-jupiter-api@${version}`);
        pom.addTestDependency(`org.junit.jupiter/junit-jupiter-engine@${version}`);
        project.testTask.exec("mvn test");
        const javaPackage = options.sampleJavaPackage ?? "org.acme";
        const javaPackagePath = javaPackage.split(".");
        new sample_file_1.SampleDir(project, path_1.join(TESTDIR, ...javaPackagePath), {
            files: {
                "MyTest.java": [
                    `package ${javaPackage};`,
                    "",
                    "import org.junit.jupiter.api.Test;",
                    "",
                    "public class MyTest {",
                    "  @Test",
                    "  public void testHello() {",
                    '    System.out.println("Hello, world!");',
                    "  }",
                    "}",
                ].join("\n"),
            },
        });
    }
}
exports.Junit = Junit;
_a = JSII_RTTI_SYMBOL_1;
Junit[_a] = { fqn: "projen.java.Junit", version: "0.65.76" };
//# sourceMappingURL=data:application/json;base64,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