"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitlabConfiguration = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const configuration_1 = require("./configuration");
const nested_configuration_1 = require("./nested-configuration");
/**
 * A GitLab CI for the main `.gitlab-ci.yml` file.
 */
class GitlabConfiguration extends configuration_1.CiConfiguration {
    constructor(project, options) {
        super(project, "gitlab-ci", options);
        this.nestedTemplates = {};
    }
    /**
     * Creates and adds nested templates to the includes of the main CI.
     * Additionally adds their stages to the main CI if they are not already present.
     * You can futher customize nested templates through the `nestedTemplates` property.
     * E.g. gitlabConfig.nestedTemplates['templateName']?.addStages('stageName')
     * @param config a record the names and configuraitons of the templates.
     */
    createNestedTemplates(config) {
        for (const [name, options] of Object.entries(config)) {
            if (this.nestedTemplates[name] !== undefined) {
                throw new Error(`${this.name}: GitLab CI already contains template "${name}".`);
            }
            const template = new nested_configuration_1.NestedConfiguration(this.project, this, name, options);
            this.nestedTemplates[template.name] = template;
            this.addIncludes({ local: template.path });
            this.addStages(...template.stages);
        }
    }
}
exports.GitlabConfiguration = GitlabConfiguration;
_a = JSII_RTTI_SYMBOL_1;
GitlabConfiguration[_a] = { fqn: "projen.gitlab.GitlabConfiguration", version: "0.65.76" };
//# sourceMappingURL=data:application/json;base64,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