"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHubProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const clobber_1 = require("../clobber");
const gitpod_1 = require("../gitpod");
const project_1 = require("../project");
const readme_1 = require("../readme");
const vscode_1 = require("../vscode");
const auto_approve_1 = require("./auto-approve");
const github_1 = require("./github");
const stale_1 = require("./stale");
/**
 * GitHub-based project.
 *
 * @deprecated This is a *temporary* class. At the moment, our base project
 * types such as `NodeProject` and `JavaProject` are derived from this, but we
 * want to be able to use these project types outside of GitHub as well. One of
 * the next steps to address this is to abstract workflows so that different
 * "engines" can be used to implement our CI/CD solutions.
 */
class GitHubProject extends project_1.Project {
    constructor(options) {
        super(options);
        this.projectType = options.projectType ?? project_1.ProjectType.UNKNOWN;
        // we only allow these global services to be used in root projects
        const github = options.github ?? (this.parent ? false : true);
        this.github = github
            ? new github_1.GitHub(this, {
                projenTokenSecret: options.projenTokenSecret,
                projenCredentials: options.projenCredentials,
                mergify: options.mergify,
                mergifyOptions: options.mergifyOptions,
                ...options.githubOptions,
            })
            : undefined;
        const vscode = options.vscode ?? (this.parent ? false : true);
        this.vscode = vscode ? new vscode_1.VsCode(this) : undefined;
        this.gitpod = options.gitpod ? new gitpod_1.Gitpod(this) : undefined;
        this.devContainer = options.devContainer
            ? new vscode_1.DevContainer(this)
            : undefined;
        if (options.clobber ?? true) {
            new clobber_1.Clobber(this);
        }
        new readme_1.SampleReadme(this, options.readme);
        if (options.autoApproveOptions && this.github) {
            this.autoApprove = new auto_approve_1.AutoApprove(this.github, options.autoApproveOptions);
        }
        const stale = options.stale ?? false;
        if (stale && this.github) {
            new stale_1.Stale(this.github, options.staleOptions);
        }
    }
    /**
     * Marks the provided file(s) as being generated. This is achieved using the
     * github-linguist attributes. Generated files do not count against the
     * repository statistics and language breakdown.
     *
     * @param glob the glob pattern to match (could be a file path).
     *
     * @see https://github.com/github/linguist/blob/master/docs/overrides.md
     */
    annotateGenerated(glob) {
        this.gitattributes.addAttributes(glob, "linguist-generated");
    }
}
exports.GitHubProject = GitHubProject;
_a = JSII_RTTI_SYMBOL_1;
GitHubProject[_a] = { fqn: "projen.github.GitHubProject", version: "0.65.76" };
//# sourceMappingURL=data:application/json;base64,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