"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstructLibraryCdktf = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const semver = require("semver");
const cdk_1 = require("../cdk");
/**
 * CDKTF construct library project
 *
 * A multi-language (jsii) construct library which vends constructs designed to
 * use within the CDK for Terraform (CDKTF), with a friendly workflow and
 * automatic publishing to the construct catalog.
 *
 * @pjid cdktf-construct
 */
class ConstructLibraryCdktf extends cdk_1.ConstructLibrary {
    constructor(options) {
        super(options);
        if (!options.cdktfVersion) {
            throw new Error("Required field cdktfVersion is not specified.");
        }
        function getDefaultConstructVersion() {
            const semverCDKTFVersion = semver.coerce(options.cdktfVersion);
            if (semverCDKTFVersion && semver.lte(semverCDKTFVersion, "0.5.0")) {
                return "^3.0.0";
            }
            return "^10.0.12";
        }
        const ver = options.cdktfVersion;
        const constructVersion = options.constructsVersion ?? getDefaultConstructVersion();
        this.addPeerDeps(`constructs@${constructVersion}`, `cdktf@${ver}`);
        this.addKeywords("cdktf");
    }
}
exports.ConstructLibraryCdktf = ConstructLibraryCdktf;
_a = JSII_RTTI_SYMBOL_1;
ConstructLibraryCdktf[_a] = { fqn: "projen.cdktf.ConstructLibraryCdktf", version: "0.65.76" };
//# sourceMappingURL=data:application/json;base64,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