"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationTestAutoDiscoverBase = exports.AutoDiscoverBase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path_1 = require("path");
const glob = require("glob");
const component_1 = require("../component");
const internal_1 = require("./internal");
/**
 * Base class for auto-discovering and creating project subcomponents.
 */
class AutoDiscoverBase extends component_1.Component {
    constructor(project, options) {
        super(project);
        const cwd = path_1.join(this.project.outdir, options.projectdir);
        this.entrypoints = glob
            .sync(`**/*${options.extension}`, { cwd })
            .map((p) => path_1.join(options.projectdir, p));
    }
}
exports.AutoDiscoverBase = AutoDiscoverBase;
_a = JSII_RTTI_SYMBOL_1;
AutoDiscoverBase[_a] = { fqn: "projen.cdk.AutoDiscoverBase", version: "0.65.76" };
/**
 * Base class for locating integration tests in the project's test tree.
 */
class IntegrationTestAutoDiscoverBase extends AutoDiscoverBase {
    constructor(project, options) {
        super(project, {
            extension: internal_1.TYPESCRIPT_INTEG_EXT,
            projectdir: options.testdir,
        });
    }
}
exports.IntegrationTestAutoDiscoverBase = IntegrationTestAutoDiscoverBase;
_b = JSII_RTTI_SYMBOL_1;
IntegrationTestAutoDiscoverBase[_b] = { fqn: "projen.cdk.IntegrationTestAutoDiscoverBase", version: "0.65.76" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0by1kaXNjb3Zlci1iYXNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2Nkay9hdXRvLWRpc2NvdmVyLWJhc2UudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwrQkFBNEI7QUFDNUIsNkJBQTZCO0FBQzdCLDRDQUF5QztBQUV6Qyx5Q0FBa0Q7QUFxQmxEOztHQUVHO0FBQ0gsTUFBc0IsZ0JBQWlCLFNBQVEscUJBQVM7SUFPdEQsWUFBWSxPQUFnQixFQUFFLE9BQWdDO1FBQzVELEtBQUssQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUVmLE1BQU0sR0FBRyxHQUFHLFdBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLE1BQU0sRUFBRSxPQUFPLENBQUMsVUFBVSxDQUFDLENBQUM7UUFFMUQsSUFBSSxDQUFDLFdBQVcsR0FBRyxJQUFJO2FBQ3BCLElBQUksQ0FBQyxPQUFPLE9BQU8sQ0FBQyxTQUFTLEVBQUUsRUFBRSxFQUFFLEdBQUcsRUFBRSxDQUFDO2FBQ3pDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsV0FBSSxDQUFDLE9BQU8sQ0FBQyxVQUFVLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUM3QyxDQUFDOztBQWZILDRDQWdCQzs7O0FBWUQ7O0dBRUc7QUFDSCxNQUFhLCtCQUFnQyxTQUFRLGdCQUFnQjtJQUNuRSxZQUNFLE9BQWdCLEVBQ2hCLE9BQStDO1FBRS9DLEtBQUssQ0FBQyxPQUFPLEVBQUU7WUFDYixTQUFTLEVBQUUsK0JBQW9CO1lBQy9CLFVBQVUsRUFBRSxPQUFPLENBQUMsT0FBTztTQUM1QixDQUFDLENBQUM7SUFDTCxDQUFDOztBQVRILDBFQVVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgam9pbiB9IGZyb20gXCJwYXRoXCI7XG5pbXBvcnQgKiBhcyBnbG9iIGZyb20gXCJnbG9iXCI7XG5pbXBvcnQgeyBDb21wb25lbnQgfSBmcm9tIFwiLi4vY29tcG9uZW50XCI7XG5pbXBvcnQgeyBQcm9qZWN0IH0gZnJvbSBcIi4uL3Byb2plY3RcIjtcbmltcG9ydCB7IFRZUEVTQ1JJUFRfSU5URUdfRVhUIH0gZnJvbSBcIi4vaW50ZXJuYWxcIjtcblxuLyoqXG4gKiBPcHRpb25zIGZvciBgQXV0b0Rpc2NvdmVyQmFzZWBcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBdXRvRGlzY292ZXJCYXNlT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBMb2NhdGUgZmlsZXMgd2l0aCB0aGUgZ2l2ZW4gZXh0ZW5zaW9uLlxuICAgKlxuICAgKiBAZXhhbXBsZSBcIi5pbnRlZy50c1wiXG4gICAqL1xuICByZWFkb25seSBleHRlbnNpb246IHN0cmluZztcblxuICAvKipcbiAgICogTG9jYXRlIGVudHJ5cG9pbnRzIGluIHRoZSBnaXZlbiBwcm9qZWN0IGRpcmVjdG9yeS5cbiAgICpcbiAgICogQGV4YW1wbGUgXCJ0ZXN0XCJcbiAgICovXG4gIHJlYWRvbmx5IHByb2plY3RkaXI6IHN0cmluZztcbn1cblxuLyoqXG4gKiBCYXNlIGNsYXNzIGZvciBhdXRvLWRpc2NvdmVyaW5nIGFuZCBjcmVhdGluZyBwcm9qZWN0IHN1YmNvbXBvbmVudHMuXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBBdXRvRGlzY292ZXJCYXNlIGV4dGVuZHMgQ29tcG9uZW50IHtcbiAgLyoqXG4gICAqIEF1dG8tZGlzY292ZXJlZCBlbnRyeSBwb2ludHMgd2l0aCBwYXRocyByZWxhdGl2ZSB0byB0aGUgcHJvamVjdFxuICAgKiBkaXJlY3RvcnkuXG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgZW50cnlwb2ludHM6IHN0cmluZ1tdO1xuXG4gIGNvbnN0cnVjdG9yKHByb2plY3Q6IFByb2plY3QsIG9wdGlvbnM6IEF1dG9EaXNjb3ZlckJhc2VPcHRpb25zKSB7XG4gICAgc3VwZXIocHJvamVjdCk7XG5cbiAgICBjb25zdCBjd2QgPSBqb2luKHRoaXMucHJvamVjdC5vdXRkaXIsIG9wdGlvbnMucHJvamVjdGRpcik7XG5cbiAgICB0aGlzLmVudHJ5cG9pbnRzID0gZ2xvYlxuICAgICAgLnN5bmMoYCoqLyoke29wdGlvbnMuZXh0ZW5zaW9ufWAsIHsgY3dkIH0pXG4gICAgICAubWFwKChwKSA9PiBqb2luKG9wdGlvbnMucHJvamVjdGRpciwgcCkpO1xuICB9XG59XG5cbi8qKlxuICogT3B0aW9ucyBmb3IgYEludGVncmF0aW9uVGVzdEF1dG9EaXNjb3ZlckJhc2VgXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSW50ZWdyYXRpb25UZXN0QXV0b0Rpc2NvdmVyQmFzZU9wdGlvbnMge1xuICAvKipcbiAgICogVGVzdCBzb3VyY2UgdHJlZS5cbiAgICovXG4gIHJlYWRvbmx5IHRlc3RkaXI6IHN0cmluZztcbn1cblxuLyoqXG4gKiBCYXNlIGNsYXNzIGZvciBsb2NhdGluZyBpbnRlZ3JhdGlvbiB0ZXN0cyBpbiB0aGUgcHJvamVjdCdzIHRlc3QgdHJlZS5cbiAqL1xuZXhwb3J0IGNsYXNzIEludGVncmF0aW9uVGVzdEF1dG9EaXNjb3ZlckJhc2UgZXh0ZW5kcyBBdXRvRGlzY292ZXJCYXNlIHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJvamVjdDogUHJvamVjdCxcbiAgICBvcHRpb25zOiBJbnRlZ3JhdGlvblRlc3RBdXRvRGlzY292ZXJCYXNlT3B0aW9uc1xuICApIHtcbiAgICBzdXBlcihwcm9qZWN0LCB7XG4gICAgICBleHRlbnNpb246IFRZUEVTQ1JJUFRfSU5URUdfRVhULFxuICAgICAgcHJvamVjdGRpcjogb3B0aW9ucy50ZXN0ZGlyLFxuICAgIH0pO1xuICB9XG59XG4iXX0=