; #############################################################################
; GENERAL ROUTINES FOR DATA HANDLING
; #############################################################################
; Please consider using of extend
; Check the header of each routine for documentation.
;
; Contents:
;    function read_data
;
; #############################################################################

undef("read_data")
function read_data(info_item[1]:logical)
;
; Arguments
;    info: a logical describing the current input file as defined in the
;          <variable>_info.ncl file in the preproc director. This is usually
;          an element of the input_file_info list.
;
; Return value
;    The actual data array with all metadata.
;
; Description
;    Retrieve the variable data and metadata based on the input_file_info
;    logical defined in the <varible>_info.ncl automatically generated by
;    the preprocessor and stored in preproc/<preproc_id>/ subdirectory.
;
; Caveats
;
; References
;
; Modification history
;   20191209-schlund_manuel: attributes from file are now added to the array
;                            returned by this function.
;   20180511-righi_mattia: adapted to the revised list-based metadata
;                          structure.
;   20180212-righi_mattia: written.
;
local funcname, scriptname, infile, fin
begin

  funcname = "read_data"
  scriptname = "interface_scripts/data_handling.ncl"
  enter_msg(scriptname, funcname)

  ; Check attribute availability
  if (.not.isatt(info_item, "filename")) then
    error_msg("f", scriptname, funcname, "filename attribute not defined " + \
              "in the interface file " + variable + "_info.ncl")
  end if
  infile = info_item@filename

  ; Check file existence and supported format
  if (.not.isfilepresent(infile)) then
    error_msg("f", scriptname, funcname, "input file " + infile + \
              " not found or not a supported format")
  end if

  ; Open file
  log_info("Reading in file = " + infile)
  fin = addfile(infile, "r")

  ; Check that variable is in the file
  if (.not. isfilevar(fin, info_item@short_name)) then
    error_msg("f", scriptname, funcname, "variable " + info_item@short_name + \
              " not found in file " + infile)
  end if

  ; Read data
  data = fin->$info_item@short_name$

  ; Copy attributes from fin (do not overwrite existing ones)
  fin_atts = getvaratts(fin)
  do idx_att = 0, dimsizes(fin_atts) - 1
    att = fin_atts(idx_att)
    if (.not. isatt(data, att)) then
      data@$att$ = fin@$att$
    end if
  end do

  leave_msg(scriptname, funcname)
  return(data)

end
