# Generated by Django 3.1.1 on 2020-09-16 07:49

import uuid

import django.db.models.deletion
from django.db import migrations, models

import revpayment.models
from revpayment.settings import api_settings


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(api_settings.BUYER_CLASS._meta.label),
    ]

    operations = [
        migrations.CreateModel(
            name="RedirectState",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("state", models.UUIDField(default=uuid.uuid4)),
                ("redirect_url", models.URLField(default="http://localhost:8000")),
                (
                    "payment_type",
                    models.CharField(
                        choices=[
                            ("offline", "offline"),
                            ("ecpay", "ecpay"),
                            ("neweb", "neweb"),
                        ],
                        default="neweb",
                        max_length=20,
                    ),
                ),
                (
                    "payment_subtype",
                    models.CharField(
                        choices=[
                            ("default", "default"),
                            ("credit", "credit"),
                            ("cvs_cod", "cvs_cod"),
                            ("cvs", "cvs"),
                            ("atm", "atm"),
                            ("web_atm", "web_atm"),
                            ("barcode", "barcode"),
                        ],
                        default="default",
                        max_length=20,
                    ),
                ),
                ("cart", models.TextField()),
                (
                    "order_id",
                    models.CharField(
                        default=revpayment.models.gen_order_id, max_length=128
                    ),
                ),
                ("order_type", models.CharField(default="default", max_length=128)),
                (
                    "buyer",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=api_settings.BUYER_CLASS._meta.label,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="PaymentInfo",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "cart",
                    models.TextField(blank=True, default=revpayment.models.empty_cart),
                ),
                ("credit", models.IntegerField(default=0)),
                (
                    "trading_slang",
                    models.CharField(
                        default=revpayment.models.random_digits, max_length=20
                    ),
                ),
                (
                    "owner",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="payment",
                        to=api_settings.BUYER_CLASS._meta.label,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="Order",
            fields=[
                (
                    "id",
                    models.CharField(
                        default=revpayment.models.gen_order_id,
                        max_length=128,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "order_type",
                    models.CharField(
                        choices=[("default", "default"), ("credit", "credit")],
                        default="default",
                        max_length=128,
                    ),
                ),
                ("amount", models.FloatField(default=0)),
                ("title", models.CharField(default="order", max_length=100)),
                (
                    "description",
                    models.CharField(default="no description", max_length=256),
                ),
                (
                    "currency",
                    models.CharField(
                        choices=[("TWD", "TWD"), ("USD", "USD"), ("JPY", "JPY")],
                        default="TWD",
                        max_length=8,
                    ),
                ),
                (
                    "payment_type",
                    models.CharField(
                        choices=[
                            ("offline", "offline"),
                            ("ecpay", "ecpay"),
                            ("neweb", "neweb"),
                        ],
                        default="neweb",
                        max_length=20,
                    ),
                ),
                (
                    "payment_subtype",
                    models.CharField(
                        choices=[
                            ("default", "default"),
                            ("credit", "credit"),
                            ("cvs_cod", "cvs_cod"),
                            ("cvs", "cvs"),
                            ("atm", "atm"),
                            ("web_atm", "web_atm"),
                            ("barcode", "barcode"),
                        ],
                        default="default",
                        max_length=20,
                    ),
                ),
                (
                    "payment_status",
                    models.CharField(
                        choices=[
                            ("success", "success"),
                            ("failure", "failure"),
                            ("refunded", "refunded"),
                            ("logistics_created", "logistics_created"),
                            ("form_created", "form_created"),
                            ("code_generated", "code_generated"),
                        ],
                        default="waiting",
                        max_length=20,
                    ),
                ),
                ("data", models.TextField(blank=True, null=True)),
                ("cart", models.TextField(blank=True, null=True)),
                ("receiver_email", models.EmailField(max_length=254)),
                ("receiver_name", models.CharField(blank=True, max_length=20)),
                ("receiver_phone", models.CharField(blank=True, max_length=20)),
                ("receiver_address", models.CharField(blank=True, max_length=128)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                ("payment_transaction_detail", models.TextField(blank=True)),
                ("payment_redirect_detail", models.TextField(blank=True)),
                ("code_no", models.CharField(blank=True, max_length=128)),
                ("bank_code", models.CharField(blank=True, max_length=128)),
                ("bank_account", models.CharField(blank=True, max_length=128)),
                ("barcode_1", models.CharField(blank=True, max_length=128)),
                ("barcode_2", models.CharField(blank=True, max_length=128)),
                ("barcode_3", models.CharField(blank=True, max_length=128)),
                (
                    "buyer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=api_settings.BUYER_CLASS._meta.label,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
    ]
