# coding: utf-8

"""
    ****************************************************************************
    Copyright (c) 2016-present,
    Jaguar0625, gimre, BloodyRookie, Tech Bureau, Corp. All rights reserved.

    This file is part of Catapult.

    Catapult is free software: you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Catapult is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Catapult. If not, see <http://www.gnu.org/licenses/>.
    ****************************************************************************
    
    Catapult REST Endpoints
    OpenAPI Specification of catapult-rest 1.1.2  # noqa: E501
    The version of the OpenAPI document: 0.9.3
    Contact: contact@nem.foundation

    NOTE: This file is auto generated by Symbol OpenAPI Generator:
    https://github.com/nemtech/symbol-openapi-generator
    Do not edit this file manually.
"""


import pprint
import re  # noqa: F401

import six

from symbol_openapi_client.configuration import Configuration


class NodeInfoDTO(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'version': 'int',
        'public_key': 'str',
        'network_generation_hash_seed': 'str',
        'roles': 'RolesTypeEnum',
        'port': 'int',
        'network_identifier': 'int',
        'friendly_name': 'str',
        'host': 'str'
    }

    attribute_map = {
        'version': 'version',
        'public_key': 'publicKey',
        'network_generation_hash_seed': 'networkGenerationHashSeed',
        'roles': 'roles',
        'port': 'port',
        'network_identifier': 'networkIdentifier',
        'friendly_name': 'friendlyName',
        'host': 'host'
    }

    def __init__(self, version=None, public_key=None, network_generation_hash_seed=None, roles=None, port=None, network_identifier=None, friendly_name=None, host=None, local_vars_configuration=None):  # noqa: E501
        """NodeInfoDTO - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._version = None
        self._public_key = None
        self._network_generation_hash_seed = None
        self._roles = None
        self._port = None
        self._network_identifier = None
        self._friendly_name = None
        self._host = None
        self.discriminator = None

        self.version = version
        self.public_key = public_key
        self.network_generation_hash_seed = network_generation_hash_seed
        self.roles = roles
        self.port = port
        self.network_identifier = network_identifier
        self.friendly_name = friendly_name
        self.host = host

    @property
    def version(self):
        """Gets the version of this NodeInfoDTO.  # noqa: E501

        Version of the application.  # noqa: E501

        :return: The version of this NodeInfoDTO.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this NodeInfoDTO.

        Version of the application.  # noqa: E501

        :param version: The version of this NodeInfoDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and version is None:  # noqa: E501
            raise ValueError("Invalid value for `version`, must not be `None`")  # noqa: E501

        self._version = version

    @property
    def public_key(self):
        """Gets the public_key of this NodeInfoDTO.  # noqa: E501

        Public key.  # noqa: E501

        :return: The public_key of this NodeInfoDTO.  # noqa: E501
        :rtype: str
        """
        return self._public_key

    @public_key.setter
    def public_key(self, public_key):
        """Sets the public_key of this NodeInfoDTO.

        Public key.  # noqa: E501

        :param public_key: The public_key of this NodeInfoDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and public_key is None:  # noqa: E501
            raise ValueError("Invalid value for `public_key`, must not be `None`")  # noqa: E501

        self._public_key = public_key

    @property
    def network_generation_hash_seed(self):
        """Gets the network_generation_hash_seed of this NodeInfoDTO.  # noqa: E501


        :return: The network_generation_hash_seed of this NodeInfoDTO.  # noqa: E501
        :rtype: str
        """
        return self._network_generation_hash_seed

    @network_generation_hash_seed.setter
    def network_generation_hash_seed(self, network_generation_hash_seed):
        """Sets the network_generation_hash_seed of this NodeInfoDTO.


        :param network_generation_hash_seed: The network_generation_hash_seed of this NodeInfoDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and network_generation_hash_seed is None:  # noqa: E501
            raise ValueError("Invalid value for `network_generation_hash_seed`, must not be `None`")  # noqa: E501

        self._network_generation_hash_seed = network_generation_hash_seed

    @property
    def roles(self):
        """Gets the roles of this NodeInfoDTO.  # noqa: E501


        :return: The roles of this NodeInfoDTO.  # noqa: E501
        :rtype: RolesTypeEnum
        """
        return self._roles

    @roles.setter
    def roles(self, roles):
        """Sets the roles of this NodeInfoDTO.


        :param roles: The roles of this NodeInfoDTO.  # noqa: E501
        :type: RolesTypeEnum
        """
        if self.local_vars_configuration.client_side_validation and roles is None:  # noqa: E501
            raise ValueError("Invalid value for `roles`, must not be `None`")  # noqa: E501

        self._roles = roles

    @property
    def port(self):
        """Gets the port of this NodeInfoDTO.  # noqa: E501

        Port used for the communication.  # noqa: E501

        :return: The port of this NodeInfoDTO.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this NodeInfoDTO.

        Port used for the communication.  # noqa: E501

        :param port: The port of this NodeInfoDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and port is None:  # noqa: E501
            raise ValueError("Invalid value for `port`, must not be `None`")  # noqa: E501

        self._port = port

    @property
    def network_identifier(self):
        """Gets the network_identifier of this NodeInfoDTO.  # noqa: E501


        :return: The network_identifier of this NodeInfoDTO.  # noqa: E501
        :rtype: int
        """
        return self._network_identifier

    @network_identifier.setter
    def network_identifier(self, network_identifier):
        """Sets the network_identifier of this NodeInfoDTO.


        :param network_identifier: The network_identifier of this NodeInfoDTO.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and network_identifier is None:  # noqa: E501
            raise ValueError("Invalid value for `network_identifier`, must not be `None`")  # noqa: E501

        self._network_identifier = network_identifier

    @property
    def friendly_name(self):
        """Gets the friendly_name of this NodeInfoDTO.  # noqa: E501

        Node friendly name.  # noqa: E501

        :return: The friendly_name of this NodeInfoDTO.  # noqa: E501
        :rtype: str
        """
        return self._friendly_name

    @friendly_name.setter
    def friendly_name(self, friendly_name):
        """Sets the friendly_name of this NodeInfoDTO.

        Node friendly name.  # noqa: E501

        :param friendly_name: The friendly_name of this NodeInfoDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and friendly_name is None:  # noqa: E501
            raise ValueError("Invalid value for `friendly_name`, must not be `None`")  # noqa: E501

        self._friendly_name = friendly_name

    @property
    def host(self):
        """Gets the host of this NodeInfoDTO.  # noqa: E501

        Node IP address.  # noqa: E501

        :return: The host of this NodeInfoDTO.  # noqa: E501
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """Sets the host of this NodeInfoDTO.

        Node IP address.  # noqa: E501

        :param host: The host of this NodeInfoDTO.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and host is None:  # noqa: E501
            raise ValueError("Invalid value for `host`, must not be `None`")  # noqa: E501

        self._host = host

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NodeInfoDTO):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, NodeInfoDTO):
            return True

        return self.to_dict() != other.to_dict()
