# AUTOGENERATED! DO NOT EDIT! File to edit: ../notebooks/linode.ipynb.

# %% auto 0
__all__ = ['LinodeClient', 'disable_firewall', 'enable_firewall']

# %% ../notebooks/linode.ipynb 1
import os
import requests
import logging

from functools import cached_property

logging.basicConfig(level=logging.INFO)

# %% ../notebooks/linode.ipynb 2
class LinodeClient:
    """
    A client instance that facilitates communication with the Linode API.
    """

    def __init__(self, token):
        self.base_url = "https://api.linode.com/v4"
        self.session = requests.Session()
        self.session.headers.update(
            {
                "Content-Type": "application/json",
                "Authorization": f"Bearer {token}",
            }
        )

    def api_call(self, method, endpoint, data=None):
        url = f"{self.base_url}{endpoint}"
        response = self.session.request(method, url, json=data)
        return response

    @cached_property
    def firewall_id(self, label="tjcloud"):
        firewalls = self.api_call("GET", "/networking/firewalls").json()["data"]
        firewall = list(filter(lambda f: f["label"] == label, firewalls))[0]
        return firewall["id"]

    def enable_firewall(self, status="enabled"):
        self.api_call(
            "PUT", f"/networking/firewalls/{self.firewall_id}", data={"status": status}
        )

    def disable_firewall(self):
        self.enable_firewall(status="disabled")

    @property
    def is_firewall_enabled(self):
        firewall = self.api_call(
            "GET", f"/networking/firewalls/{self.firewall_id}"
        ).json()
        return firewall["status"] == "enabled"

# %% ../notebooks/linode.ipynb 5
def disable_firewall():
    client = LinodeClient(os.getenv("LINODE_TOKEN"))
    if client.is_firewall_enabled:
        client.disable_firewall()
        logging.info("Firewall disabled")
    else:
        logging.info("Firewall already disabled")


def enable_firewall():
    client = LinodeClient(os.getenv("LINODE_TOKEN"))
    if not client.is_firewall_enabled:
        client.enable_firewall()
        logging.info("Firewall enabled")
    else:
        logging.info("Firewall already enabled")
