# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tjcloud']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.28.1,<3.0.0']

entry_points = \
{'console_scripts': ['disable_firewall = tjcloud.linode:disable_firewall',
                     'enable_firewall = tjcloud.linode:enable_firewall']}

setup_kwargs = {
    'name': 'tjcloud',
    'version': '2.2.0',
    'description': 'TJ Palanca Personal Cloud',
    'long_description': 'TJCloud\n================\n\n<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->\n\n> This is my personal cloud - for hobby programming, personal projects,\n> and experiments.\n\n## Key Technologies\n\nI’m leaning on the following core technologies:\n\n- [Terraform](https://www.terraform.io) (and [Terraform\n  Cloud](https://app.terraform.io/) or [Github\n  Actions](https://github.com/features/actions)) for provisioning\n  infrastructure as code,\n- [Kubernetes](https://kubernetes.io) for orchestrating various\n  workloads, with a few general patterns:\n  - [NGINX Ingress](https://kubernetes.github.io/ingress-nginx/) for\n    exposing web services to the web from the cluster\n  - Databases as stateful deployments\n  - [Keycloak](https://www.keycloak.org) for identity and access\n    management\n  - [OAuth2 Proxy](https://oauth2-proxy.github.io/oauth2-proxy/) as main\n    gateway to protect private services\n  - [Kaniko](https://github.com/GoogleContainerTools/kaniko) for\n    building images inside a Kubernetes cluster\n- [Linode Kubernetes\n  Engine](https://www.linode.com/products/kubernetes/), a simple,\n  developer-friendly, and inexpensive cloud provider for managed\n  Kubernetes, and\n- [Linode Object\n  Storage](https://www.linode.com/products/object-storage/) for storing\n  data files\n- [Cloudflare](https://www.cloudflare.com) for DNS, TLS, and all-around\n  protection. Some key features are:\n  - Everything proxied through cloudflare network\n  - Origin certificate presented to cloudflare\n  - Cloudflare sends client certificate and server verifies\n- [GitHub Packages](https://github.com/features/packages) as my main\n  image registry\n\n## Applications\n\nAs of this writing, I host the following applications:\n\n- a VS Code instance from\n  [code-server](https://github.com/coder/code-server) that allows me to\n  develop on the cloud, with any device (including iPads and\n  chromebooks!). Some special features are:\n  - Protected domains (https://\\<port\\>.\\<domain\\>) to test web apps\n    running on the server or for exposing environments like Jupyter or\n    Pluto\n  - Custom web fonts through an NGINX sub_filter\n  - Python, Julia, JS, and R installations for the confused data person\n- [PGAdmin](https://www.pgadmin.org), an excellent open source\n  administration console for PostgreSQL\n- [PostgreSQL](https://www.postgresql.org) for my main database\n- [Clickhouse](https://clickhouse.com) as a requirement for Plausible\n  Analytics, storing clickstream data\n- [Redis](https://redis.io) as a requirement for Mastodon, but also for\n  general caching in the development server\n- [Plausible Analytics](https://plausible.io) for hosting\n  privacy-friendly website analytics\n- the [Kubernetes Dashboard](https://github.com/kubernetes/dashboard)\n  for administering the cluster, and\n  [metrics-server](https://github.com/kubernetes-sigs/metrics-server)\n  for collecting data to present in the dashboard.\n- [Mastodon](https://joinmastodon.org) - my own personal Mastodon server\n  for interacting with the Fediverse (open source Twitter but less\n  annoying virality and more useful, insightful content)\n',
    'author': 'TJ P',
    'author_email': 'code@tjpalanca.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://tjpalanca.com/tjcloud',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.11,<4.0',
}


setup(**setup_kwargs)
