# Blaupause - Python package template
Martin Lang<sup>1</sup> and Marijan Beg<sup>1</sup>

<sup>1</sup> *Faculty of Engineering and Physical Sciences, University of Southampton, Southampton SO17 1BJ, United Kingdom*

| Description | Badge |
| --- | --- |
| Builds | [![Build status](https://ci.appveyor.com/api/projects/status/k4wb6m7btqy9lj86/branch/main?svg=true)](https://ci.appveyor.com/project/lang-m/blaupause/branch/main)|
|     | [![Build Status](https://travis-ci.org/lang-m/blaupause.svg?branch=main)](https://travis-ci.org/lang-m/blaupause) |
| Coverage | [![codecov](https://codecov.io/gh/lang-m/blaupause/branch/master/graph/badge.svg?token=90KVILJ4F4)](https://codecov.io/gh/lang-m/blaupause) |
| Documentation | [![Documentation Status](https://readthedocs.org/projects/blaupause/badge/?version=latest)](https://blaupause.readthedocs.io/en/latest/?badge=latest)|
| Binder | [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/lang-m/blaupause/main?filepath=docs%2Fipynb%2Findex.ipynb) |
| License | [![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](https://opensource.org/licenses/BSD-3-Clause) |
| DOI | [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.4327500.svg)](https://doi.org/10.5281/zenodo.4327500) |

## About

A sample Python-based package that can be used a tutorial for setting up a project.

Demonstrated are:
- Testing with pytest/doctests
- continuous integration
  - Travis
  - Appveyor
  - soon: GitHub actions
- code coverage
- docker
- make files
- packaging
- documentation
- licensing

It is available on Windows, MacOS, and Linux. It requires Python 3.8+.

## Documentation

APIs and tutorials are available in documentation. To access them, use the documentation badge in the table above.

## Installation, testing, and upgrade

We recommend installation using `conda` package manager. Instructions can be found in the documentation.

## Binder

This package can be used in the cloud via Binder. To access Binder, use the Binder badge in the table above.

## Support

If you require support, have questions, want to report a bug, or want to suggest an improvement, please raise an issue in this repository.

## License

Licensed under the BSD 3-Clause "New" or "Revised" License. For details, please refer to the [LICENSE](LICENSE) file.

## How to cite

Please cite this package as:

Martin Lang and Marijan Beg. Blaupause - Python package template. Zenodo. DOI: [10.5281/zenodo.4327500](http://doi.org/10.5281/zenodo.4327500) (2020).

## Acknowledgements

- EPSRC Programme grant on [Skyrmionics](http://www.skyrmions.ac.uk) (EP/N032128/1).
