"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateJobExecutor = exports.FargateRunner = exports.JobExecutorImage = exports.FargateCapacityProviderType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("@aws-cdk/aws-ec2");
const ecs = require("@aws-cdk/aws-ecs");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * Amazon ECS Capacity Providers for AWS Fargate.
 *
 * @stability stable
 */
var FargateCapacityProviderType;
(function (FargateCapacityProviderType) {
    FargateCapacityProviderType["FARGATE"] = "FARGATE";
    FargateCapacityProviderType["FARGATE_SPOT"] = "FARGATE_SPOT";
})(FargateCapacityProviderType = exports.FargateCapacityProviderType || (exports.FargateCapacityProviderType = {}));
/**
 * The docker image for the job executor.
 *
 * @stability stable
 */
class JobExecutorImage {
    /**
     *
     * @param image job executor image URI
     */
    constructor(uri) {
        this.uri = uri;
    }
    /**
     * Custom image.
     *
     * @param image custom image registry URI.
     * @stability stable
     */
    static of(image) { return new JobExecutorImage(image); }
}
exports.JobExecutorImage = JobExecutorImage;
_a = JSII_RTTI_SYMBOL_1;
JobExecutorImage[_a] = { fqn: "cdk-gitlab.JobExecutorImage", version: "0.1.50" };
/**
 * Debian.
 *
 * @see https://gitlab.com/tmaczukin-test-projects/fargate-driver-debian
 * @stability stable
 */
JobExecutorImage.DEBIAN = JobExecutorImage.of('registry.gitlab.com/tmaczukin-test-projects/fargate-driver-debian:latest');
/**
 * Node.
 *
 * @see https://gitlab.com/aws-fargate-driver-demo/docker-nodejs-gitlab-ci-fargate
 * @stability stable
 */
JobExecutorImage.NODE = JobExecutorImage.of('registry.gitlab.com/aws-fargate-driver-demo/docker-nodejs-gitlab-ci-fargate:latest');
/**
 * JSII for AWS CDK.
 *
 * @see https://gitlab.com/pahud/docker-jsii-cdk-gitlab-ci-fargate
 * @stability stable
 */
JobExecutorImage.JSII = JobExecutorImage.of('registry.gitlab.com/pahud/docker-jsii-cdk-gitlab-ci-fargate:latest');
const CLUSTER_DEFAULT_CAPACITY_PROVIDER = [
    FargateCapacityProviderType.FARGATE,
    FargateCapacityProviderType.FARGATE_SPOT,
];
const DEFAULT_CLUSTER_CAPACITY_PROVIDER_STRATEGY = [{
        base: 0,
        weight: 1,
        capacityProvider: FargateCapacityProviderType.FARGATE_SPOT,
    }];
const DEFAULT_SERVICE_CAPACITY_PROVIDER_STRATEGY = [
    { base: 0, weight: 0, capacityProvider: FargateCapacityProviderType.FARGATE },
    { weight: 1, capacityProvider: FargateCapacityProviderType.FARGATE_SPOT },
];
/**
 * The FargateRunner.
 *
 * @stability stable
 */
class FargateRunner extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w;
        super(scope, id);
        this.vpc = props.vpc;
        const stack = cdk.Stack.of(this);
        const fargateSubnet = this.vpc.selectSubnets(props.fargateJobSubnet);
        const cluster = new ecs.Cluster(this, 'Cluster', { vpc: this.vpc });
        const cfnCluster = cluster.node.tryFindChild('Resource');
        cfnCluster.addPropertyOverride('CapacityProviders', CLUSTER_DEFAULT_CAPACITY_PROVIDER);
        cfnCluster.addPropertyOverride('DefaultCapacityProviderStrategy', (_d = props.serviceDefaultCapacityProviderStrategy) !== null && _d !== void 0 ? _d : DEFAULT_CLUSTER_CAPACITY_PROVIDER_STRATEGY);
        const runnerTask = new ecs.FargateTaskDefinition(this, 'RunnerTask', {
            cpu: 256,
            memoryLimitMiB: 512,
        });
        const fargateSecurityGroup = (_e = props.securityGroup) !== null && _e !== void 0 ? _e : this.createSecurityGroup();
        const registrationToken = (_f = props.registrationToken) !== null && _f !== void 0 ? _f : (this.node.tryGetContext('GITLAB_REGISTRATION_TOKEN') || process.env.GITLAB_REGISTRATION_TOKEN);
        if (!registrationToken) {
            throw new Error('missing GITLAB_REGISTRATION_TOKEN in the context variable');
        }
        runnerTask.addContainer('runner', {
            image: ecs.ContainerImage.fromRegistry('registry.gitlab.com/pahud/docker-gitlab-runner-fargate-driver'),
            logging: new ecs.AwsLogDriver({ streamPrefix: 'GitlabRunnerManager', logRetention: 7 }),
            environment: {
                GITLAB_REGISTRATION_TOKEN: registrationToken,
                GITLAB_URL: (_g = props.gitlabURL) !== null && _g !== void 0 ? _g : 'https://gitlab.com',
                FARGATE_REGION: (_j = (_h = props.executor) === null || _h === void 0 ? void 0 : _h.region) !== null && _j !== void 0 ? _j : stack.region,
                FARGATE_CLUSTER: (_m = (_l = (_k = props.executor) === null || _k === void 0 ? void 0 : _k.cluster) === null || _l === void 0 ? void 0 : _l.clusterName) !== null && _m !== void 0 ? _m : cluster.clusterName,
                FARGATE_SUBNET: (_q = (_p = (_o = props.executor) === null || _o === void 0 ? void 0 : _o.subnet) === null || _p === void 0 ? void 0 : _p.subnetId) !== null && _q !== void 0 ? _q : fargateSubnet.subnetIds[0],
                FARGATE_SECURITY_GROUP: (_t = (_s = (_r = props.executor) === null || _r === void 0 ? void 0 : _r.securityGroup) === null || _s === void 0 ? void 0 : _s.securityGroupId) !== null && _t !== void 0 ? _t : fargateSecurityGroup.securityGroupId,
                FARGATE_TASK_DEFINITION: ((_u = props.executor) === null || _u === void 0 ? void 0 : _u.taskDefinitionArn) || new FargateJobExecutor(this, 'JobExecutor').taskDefinitionArn,
                RUNNER_TAG_LIST: this.synthesizeTags((_v = props.tags) !== null && _v !== void 0 ? _v : ['fargate', 'gitlab', 'aws', 'docker']),
            },
        });
        runnerTask.taskRole.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AmazonECS_FullAccess'));
        const svc = new ecs.FargateService(this, 'RunnerManagerService', {
            cluster,
            taskDefinition: runnerTask,
            securityGroups: [fargateSecurityGroup],
        });
        const cfnService = svc.node.tryFindChild('Service');
        cfnService.addPropertyDeletionOverride('LaunchType');
        cfnService.addPropertyOverride('CapacityProviderStrategy', (_w = props.serviceDefaultCapacityProviderStrategy) !== null && _w !== void 0 ? _w : DEFAULT_SERVICE_CAPACITY_PROVIDER_STRATEGY);
    }
    synthesizeTags(tags) {
        return tags.join(',');
    }
    createSecurityGroup() {
        const sg = new ec2.SecurityGroup(this, 'FargateSecurityGroup', { vpc: this.vpc });
        sg.connections.allowInternally(ec2.Port.allTraffic());
        return sg;
    }
}
exports.FargateRunner = FargateRunner;
_b = JSII_RTTI_SYMBOL_1;
FargateRunner[_b] = { fqn: "cdk-gitlab.FargateRunner", version: "0.1.50" };
/**
 * The FargateJobExecutor.
 *
 * @stability stable
 */
class FargateJobExecutor extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _d, _e;
        super(scope, id);
        this.region = (_d = props.region) !== null && _d !== void 0 ? _d : cdk.Stack.of(this).region;
        this.cluster = props.cluster;
        this.subnet = props.subnet;
        this.securityGroup = props.securityGroup;
        const task = new ecs.FargateTaskDefinition(this, 'JobsTask', {
            cpu: 256,
            memoryLimitMiB: 512,
        });
        this.taskDefinitionArn = task.taskDefinitionArn;
        const image = (_e = props.image) !== null && _e !== void 0 ? _e : JobExecutorImage.DEBIAN;
        task.addContainer('ci-coordinator', {
            image: ecs.ContainerImage.fromRegistry(image.uri.toString()),
            logging: new ecs.AwsLogDriver({ streamPrefix: 'GitlabRunnerJob', logRetention: 7 }),
        }).addPortMappings({ containerPort: 22 });
    }
}
exports.FargateJobExecutor = FargateJobExecutor;
_c = JSII_RTTI_SYMBOL_1;
FargateJobExecutor[_c] = { fqn: "cdk-gitlab.FargateJobExecutor", version: "0.1.50" };
//# sourceMappingURL=data:application/json;base64,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